/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.gmail.mirelatrue.xpbank.API;
import com.gmail.mirelatrue.xpbank.Account;
import com.gmail.mirelatrue.xpbank.GroupBank;
import com.gmail.mirelatrue.xpbank.XPBank;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_XPBank
extends AbstractEconomy {
    private final Logger log;
    private final String name = "XPBank";
    private Plugin plugin = null;
    private XPBank XPB = null;
    private API api = null;

    public Economy_XPBank(Plugin plugin) {
        Plugin economy;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.XPB == null && (economy = plugin.getServer().getPluginManager().getPlugin("XPBank")) != null && economy.isEnabled()) {
            this.XPB = (XPBank)economy;
            this.api = this.XPB.getAPI();
            this.log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "XPBank"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.XPB != null;
    }

    @Override
    public String getName() {
        return "XPBank";
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public String format(double amount) {
        return String.format("%d %s", (int)amount, this.api.currencyName((int)amount));
    }

    @Override
    public String currencyNamePlural() {
        return this.api.getMsg("CurrencyNamePlural");
    }

    @Override
    public String currencyNameSingular() {
        return this.api.getMsg("currencyName");
    }

    @Override
    public boolean hasAccount(String playerName) {
        Account account = this.api.getAccount(playerName);
        return account != null;
    }

    @Override
    public double getBalance(String playerName) {
        Account account = this.api.getAccount(playerName);
        return account.getBalance();
    }

    @Override
    public boolean has(String playerName, double amount) {
        Account account = this.api.getAccount(playerName);
        return account.getBalance() >= (int)amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        Account account = this.api.getAccount(playerName);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("Player doesn't exist."));
        }
        int value = (int)amount;
        int balance = account.getBalance();
        if (value < 1) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("LessThanZero"));
        }
        if (value > balance) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, String.format(this.api.getMsg("InsufficientXP"), this.api.currencyName(value)));
        }
        account.modifyBalance(-value);
        return new EconomyResponse(value, balance - value, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        Account account = this.api.getAccount(playerName);
        if (account == null) {
            this.createPlayerAccount(playerName);
        }
        int value = (int)amount;
        int balance = account.getBalance();
        if (value < 1) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("LessThanZero"));
        }
        account.addTaxableIncome(value);
        return new EconomyResponse(value, balance + value, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank != null) {
            return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.FAILURE, String.format(this.api.getMsg("GroupBankExists"), name));
        }
        Account account = this.api.getAccount(player);
        groupBank = this.api.createGroupBank(name, account);
        return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        this.api.deleteGroupBank(groupBank, String.format(this.api.getMsg("Disbanded"), groupBank.getName()));
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        int value = (int)amount;
        int balance = groupBank.getBalance();
        if (balance >= value) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, String.format(this.api.getMsg("InsufficientXP"), this.api.currencyName(value)));
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        int value = (int)amount;
        int balance = groupBank.getBalance();
        if (value < 1) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("LessThanZero"));
        }
        if (value > balance) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, String.format(this.api.getMsg("InsufficientXP"), this.api.currencyName(value)));
        }
        groupBank.modifyBalance(-value);
        return new EconomyResponse(value, balance - value, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        int value = (int)amount;
        int balance = groupBank.getBalance();
        if (value < 1) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("LessThanZero"));
        }
        groupBank.modifyBalance(value);
        return new EconomyResponse(value, balance + value, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        Account account = this.api.getAccount(name);
        if (account == null) {
            return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.FAILURE, this.api.getMsg("PlayerNotExist"));
        }
        if (groupBank.getOwner().equalsIgnoreCase(name)) {
            return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.FAILURE, String.format(this.api.getMsg("PlayerNotOwner"), account.getName(), groupBank.getName()));
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        GroupBank groupBank = this.api.getGroupBank(name);
        if (groupBank == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, this.api.getMsg("GroupBankNotExists"));
        }
        Account account = this.api.getAccount(name);
        if (account == null) {
            return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.FAILURE, this.api.getMsg("PlayerNotExist"));
        }
        if (groupBank.groupMembers.getMembers().containsKey(playerName)) {
            return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, groupBank.getBalance(), EconomyResponse.ResponseType.FAILURE, String.format(this.api.getMsg("NotAMemberOf"), groupBank.getName(), account.getName()));
    }

    @Override
    public List<String> getBanks() {
        return this.api.getAllGroupBanks();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        this.api.createAccount(playerName);
        return true;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_XPBank economy = null;

        public EconomyServerListener(Economy_XPBank economy_XPBank) {
            this.economy = economy_XPBank;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.XPB == null && (eco = event.getPlugin()).getDescription().getName().equals("XPBank")) {
                this.economy.XPB = (XPBank)eco;
                Economy_XPBank.this.api = Economy_XPBank.this.XPB.getAPI();
                Economy_XPBank.this.log.info(String.format("[%s][Economy] %s hooked.", Economy_XPBank.this.plugin.getDescription().getName(), "XPBank"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.XPB != null && event.getPlugin().getDescription().getName().equals("XPBank")) {
                this.economy.XPB = null;
                Economy_XPBank.this.log.info(String.format("[%s][Economy] %s unhooked.", Economy_XPBank.this.plugin.getDescription().getName(), "XPBank"));
            }
        }
    }
}

