/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.gmail.bleedobsidian.miconomy.Main;
import com.gmail.bleedobsidian.miconomy.MiConomy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_MiConomy
extends AbstractEconomy {
    private final Logger log;
    private final String name = "MiConomy";
    private Plugin plugin;
    private MiConomy economy;
    private Main miConomy;

    public Economy_MiConomy(Plugin plugin) {
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.miConomy == null) {
            Plugin miConomyPlugin = plugin.getServer().getPluginManager().getPlugin("MiConomy");
            if (this.miConomy != null) {
                this.miConomy = (Main)miConomyPlugin;
                this.economy = this.miConomy.getInstance();
                this.log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "MiConomy"));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.miConomy == null) {
            return false;
        }
        return this.miConomy.isEnabled();
    }

    @Override
    public String getName() {
        return "MiConomy";
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public int fractionalDigits() {
        return 2;
    }

    @Override
    public String format(double amount) {
        return this.economy.getFormattedValue(amount);
    }

    @Override
    public String currencyNamePlural() {
        return this.miConomy.getPluginConfig().MoneyNamePlural;
    }

    @Override
    public String currencyNameSingular() {
        return this.miConomy.getPluginConfig().MoneyName;
    }

    @Override
    public boolean hasAccount(String playerName) {
        List worlds = this.plugin.getServer().getWorlds();
        return this.hasAccount(playerName, ((World)worlds.get(0)).getName());
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        World world = this.plugin.getServer().getWorld(worldName);
        return this.economy.isAccountCreated(player, world);
    }

    @Override
    public double getBalance(String playerName) {
        List worlds = this.plugin.getServer().getWorlds();
        return this.getBalance(playerName, ((World)worlds.get(0)).getName());
    }

    @Override
    public double getBalance(String playerName, String worldName) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        World world = this.plugin.getServer().getWorld(worldName);
        return this.economy.getAccountBalance(player, world);
    }

    @Override
    public boolean has(String playerName, double amount) {
        List worlds = this.plugin.getServer().getWorlds();
        return this.has(playerName, ((World)worlds.get(0)).getName(), amount);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        World world;
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        double playerBalance = this.economy.getAccountBalance(player, world = this.plugin.getServer().getWorld(worldName));
        return playerBalance >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        List worlds = this.plugin.getServer().getWorlds();
        return this.withdrawPlayer(playerName, ((World)worlds.get(0)).getName(), amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        World world = this.plugin.getServer().getWorld(worldName);
        double balance = this.economy.getAccountBalance(player, world);
        if (this.getBalance(playerName, worldName) < amount) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        if (this.economy.removeAccountBalance(player, amount, world)) {
            balance = this.economy.getAccountBalance(player, world);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Failed to remove funds from account");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        List worlds = this.plugin.getServer().getWorlds();
        return this.depositPlayer(playerName, ((World)worlds.get(0)).getName(), amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        World world = this.plugin.getServer().getWorld(worldName);
        double balance = this.economy.getAccountBalance(player, world);
        if (this.economy.addAccountBalance(player, amount, world)) {
            balance = this.economy.getAccountBalance(player, world);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Failed to add funds to account");
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(player);
        ArrayList<OfflinePlayer> owners = new ArrayList<OfflinePlayer>();
        owners.add(owner);
        if (!this.economy.isBankCreated(name)) {
            this.economy.createBank(name, owners, new ArrayList(), false);
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "A bank with this name already exists");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        if (this.economy.isBankCreated(name)) {
            this.economy.deleteBank(name);
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        if (this.economy.isBankCreated(name)) {
            double balance = this.economy.getBankBalance(name);
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        if (this.economy.isBankCreated(name)) {
            double balance = this.economy.getBankBalance(name);
            if (balance >= amount) {
                return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        if (this.economy.isBankCreated(name)) {
            this.economy.removeBankBalance(name, amount);
            double balance = this.economy.getBankBalance(name);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (this.economy.isBankCreated(name)) {
            this.economy.addBankBalance(name, amount);
            double balance = this.economy.getBankBalance(name);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(playerName);
        if (this.economy.isBankCreated(name)) {
            if (this.economy.isPlayerBankOwner(name, owner)) {
                return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "The player is not a bank owner");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(playerName);
        if (this.economy.isBankCreated(name)) {
            if (this.economy.isPlayerBankMember(name, owner)) {
                return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "The player is not a bank member");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank doesn't exist");
    }

    @Override
    public List<String> getBanks() {
        return this.economy.getBanks();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        List worlds = this.plugin.getServer().getWorlds();
        return this.createPlayerAccount(playerName, ((World)worlds.get(0)).getName());
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        World world;
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        if (!this.economy.isAccountCreated(player, world = this.plugin.getServer().getWorld(worldName))) {
            this.economy.createAccount(player, 0.0, world);
            return true;
        }
        return false;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_MiConomy economy = null;

        public EconomyServerListener(Economy_MiConomy economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin miConomyPlugin;
            if (this.economy.economy == null && (miConomyPlugin = event.getPlugin()).getDescription().getName().equals("MiConomy")) {
                this.economy.miConomy = (Main)miConomyPlugin;
                this.economy.economy = Economy_MiConomy.this.miConomy.getInstance();
                Economy_MiConomy.this.log.info(String.format("[%s][Economy] %s hooked.", Economy_MiConomy.this.plugin.getDescription().getName(), "MiConomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("MiConomy")) {
                this.economy.miConomy = null;
                this.economy.economy = null;
                Economy_MiConomy.this.log.info(String.format("[%s][Economy] %s unhooked.", Economy_MiConomy.this.plugin.getDescription().getName(), "MiConomy"));
            }
        }
    }
}

