/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import boardinggamer.mcmoney.McMoneyAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_McMoney
extends AbstractEconomy {
    private final Logger log;
    private final String name = "McMoney";
    private Plugin plugin = null;
    private McMoneyAPI economy = null;

    public Economy_McMoney(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (econ = plugin.getServer().getPluginManager().getPlugin("McMoney")) != null && econ.isEnabled()) {
            this.economy = McMoneyAPI.getInstance();
            this.log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "McMoney"));
        }
    }

    @Override
    public String getName() {
        return "McMoney";
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null;
    }

    @Override
    public double getBalance(String playerName) {
        return this.economy.getMoney(playerName);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        double balance = this.economy.getMoney(playerName);
        if (amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (balance - amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        this.economy.removeMoney(playerName, amount);
        return new EconomyResponse(amount, this.economy.getMoney(playerName), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        double balance = this.economy.getMoney(playerName);
        if (amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        this.economy.addMoney(playerName, amount);
        return new EconomyResponse(amount, this.economy.getMoney(playerName), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public String currencyNamePlural() {
        return this.economy.moneyNamePlural();
    }

    @Override
    public String currencyNameSingular() {
        return this.economy.moneyNameSingle();
    }

    @Override
    public String format(double amount) {
        if ((amount = Math.ceil(amount)) == 1.0) {
            return String.format("%d %s", (int)amount, this.currencyNameSingular());
        }
        return String.format("%d %s", (int)amount, this.currencyNamePlural());
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "McMoney does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.economy.playerExists(playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (!this.hasAccount(playerName)) {
            this.economy.setMoney(playerName, 0.0);
            return true;
        }
        return false;
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_McMoney economy = null;

        public EconomyServerListener(Economy_McMoney economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.economy == null && (eco = event.getPlugin()).getDescription().getName().equals("McMoney")) {
                this.economy.economy = McMoneyAPI.getInstance();
                Economy_McMoney.this.log.info(String.format("[%s][Economy] %s hooked.", Economy_McMoney.this.plugin.getDescription().getName(), "McMoney"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("McMoney")) {
                this.economy.economy = null;
                Economy_McMoney.this.log.info(String.format("[%s][Economy] %s unhooked.", Economy_McMoney.this.plugin.getDescription().getName(), "McMoney"));
            }
        }
    }
}

