/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.flobi.GoldIsMoney2.GoldIsMoney;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_GoldIsMoney2
extends AbstractEconomy {
    private final Logger log;
    private final String name = "GoldIsMoney";
    private Plugin plugin = null;
    protected GoldIsMoney economy = null;

    public Economy_GoldIsMoney2(Plugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("GoldIsMoney")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.flobi.GoldIsMoney2.GoldIsMoney")) {
            this.economy = (GoldIsMoney)ec;
            this.log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "GoldIsMoney"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return "GoldIsMoney";
    }

    @Override
    public boolean hasBankSupport() {
        return GoldIsMoney.hasBankSupport();
    }

    @Override
    public int fractionalDigits() {
        return GoldIsMoney.fractionalDigits();
    }

    @Override
    public String format(double amount) {
        return GoldIsMoney.format((double)amount);
    }

    @Override
    public String currencyNamePlural() {
        return GoldIsMoney.currencyNamePlural();
    }

    @Override
    public String currencyNameSingular() {
        return GoldIsMoney.currencyNameSingular();
    }

    @Override
    public boolean hasAccount(String playerName) {
        return GoldIsMoney.hasAccount((String)playerName);
    }

    @Override
    public double getBalance(String playerName) {
        return GoldIsMoney.getBalance((String)playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return GoldIsMoney.has((String)playerName, (double)amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds!");
        }
        if (!GoldIsMoney.hasAccount((String)playerName)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player does not have an account!");
        }
        if (!GoldIsMoney.has((String)playerName, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.getBalance((String)playerName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        if (!GoldIsMoney.withdrawPlayer((String)playerName, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.getBalance((String)playerName), EconomyResponse.ResponseType.FAILURE, "Unable to withdraw funds!");
        }
        return new EconomyResponse(amount, GoldIsMoney.getBalance((String)playerName), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds!");
        }
        if (!GoldIsMoney.hasAccount((String)playerName)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player does not have an account!");
        }
        if (!GoldIsMoney.depositPlayer((String)playerName, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.getBalance((String)playerName), EconomyResponse.ResponseType.FAILURE, "Unable to deposit funds!");
        }
        return new EconomyResponse(amount, GoldIsMoney.getBalance((String)playerName), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.createBank((String)name, (String)player)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create bank account.");
        }
        return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.deleteBank((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to remove bank account.");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.bankExists((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.bankExists((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (GoldIsMoney.bankHas((String)name, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.bankExists((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (!GoldIsMoney.bankHas((String)name, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        if (!GoldIsMoney.bankWithdraw((String)name, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.FAILURE, "Unable to withdraw from that bank account!");
        }
        return new EconomyResponse(amount, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.bankExists((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (!GoldIsMoney.bankDeposit((String)name, (double)amount)) {
            return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.FAILURE, "Unable to deposit to that bank account!");
        }
        return new EconomyResponse(amount, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.bankExists((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (!GoldIsMoney.isBankOwner((String)name, (String)playerName)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player does not own that bank!");
        }
        return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        if (!GoldIsMoney.hasBankSupport()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney bank support is disabled!");
        }
        if (!GoldIsMoney.bankExists((String)name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (!GoldIsMoney.isBankMember((String)name, (String)playerName)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player is not a member of that bank!");
        }
        return new EconomyResponse(0.0, GoldIsMoney.bankBalance((String)name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public List<String> getBanks() {
        return GoldIsMoney.getBanks();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return GoldIsMoney.createPlayerAccount((String)playerName);
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_GoldIsMoney2 economy = null;

        public EconomyServerListener(Economy_GoldIsMoney2 economy_GoldIsMoney2) {
            this.economy = economy_GoldIsMoney2;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin ec;
            if (this.economy.economy == null && (ec = event.getPlugin()).getClass().getName().equals("com.flobi.GoldIsMoney2.GoldIsMoney")) {
                this.economy.economy = (GoldIsMoney)ec;
                Economy_GoldIsMoney2.this.log.info(String.format("[%s][Economy] %s hooked.", Economy_GoldIsMoney2.this.plugin.getDescription().getName(), "GoldIsMoney"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("GoldIsMoney")) {
                this.economy.economy = null;
                Economy_GoldIsMoney2.this.log.info(String.format("[%s][Economy] %s unhooked.", Economy_GoldIsMoney2.this.plugin.getDescription().getName(), "GoldIsMoney"));
            }
        }
    }
}

