/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.utils.bukkit;

import be.maximvdw.placeholderapi.internal.utils.NumberUtils;

public class Version
implements Comparable<Version> {
    private short major;
    private short minor;
    private short release;
    private boolean alpha;
    private boolean beta;

    public Version() {
    }

    public Version(String version) {
        String[] data = version.split("\\.");
        if (data.length == 3) {
            if (NumberUtils.isInteger(data[0])) {
                this.major = (short)Integer.parseInt(data[0]);
            }
            if (this.major == 0) {
                this.alpha = true;
            }
            if (NumberUtils.isInteger(data[1])) {
                this.minor = (short)Integer.parseInt(data[1]);
            }
            if (data[2].contains("b")) {
                this.beta = true;
            }
            if (NumberUtils.isInteger(data[2].replace("b", ""))) {
                this.release = (short)Integer.parseInt(data[2].replace("b", ""));
            }
        }
    }

    public boolean isBeta() {
        return this.beta;
    }

    public boolean isAlpha() {
        return this.alpha;
    }

    public short getMajor() {
        return this.major;
    }

    public Version setMajor(short major) {
        this.major = major;
        return this;
    }

    public short getMinor() {
        return this.minor;
    }

    public Version setMinor(short minor) {
        this.minor = minor;
        return this;
    }

    public short getRelease() {
        return this.release;
    }

    public Version setRelease(short release) {
        this.release = release;
        return this;
    }

    public int compare(Version otherVersion) {
        if (otherVersion.getMajor() > this.getMajor()) {
            return 1;
        }
        if (otherVersion.getMajor() < this.getMajor()) {
            return -1;
        }
        if (otherVersion.getMinor() > this.getMinor()) {
            return 1;
        }
        if (otherVersion.getMinor() < this.getMinor()) {
            return -1;
        }
        if (otherVersion.getRelease() > this.getRelease()) {
            return 1;
        }
        if (otherVersion.getRelease() < this.getRelease()) {
            return -1;
        }
        if (otherVersion.isBeta() == this.isBeta()) {
            return 0;
        }
        if (otherVersion.isBeta()) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        String version = this.major + "." + this.minor + "." + this.release;
        if (this.isBeta()) {
            version = version + "b";
        }
        return version;
    }

    @Override
    public int compareTo(Version otherVersion) {
        if (otherVersion.getMajor() > this.getMajor()) {
            return 1;
        }
        if (otherVersion.getMajor() < this.getMajor()) {
            return -1;
        }
        if (otherVersion.getMinor() > this.getMinor()) {
            return 1;
        }
        if (otherVersion.getMinor() < this.getMinor()) {
            return -1;
        }
        if (otherVersion.getRelease() > this.getRelease()) {
            return 1;
        }
        if (otherVersion.getRelease() < this.getRelease()) {
            return -1;
        }
        if (otherVersion.isBeta() == this.isBeta()) {
            return 0;
        }
        if (otherVersion.isBeta()) {
            return -1;
        }
        return 1;
    }
}

