/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class ReflectionUtil {
    private static volatile Map<Class<?>, Class<?>> CORRESPONDING_TYPES = new HashMap();
    public static Class<?> obcPlayer = ReflectionUtil.getOBCClass("entity.CraftPlayer");
    public static Method methodPlayerGetHandle = ReflectionUtil.getMethod("getHandle", obcPlayer, new Class[0]);

    private static Class<?> getPrimitiveType(Class<?> clazz) {
        return CORRESPONDING_TYPES.containsKey(clazz) ? CORRESPONDING_TYPES.get(clazz) : clazz;
    }

    private static Class<?>[] toPrimitiveTypeArray(Object[] objects) {
        int a = objects != null ? objects.length : 0;
        Class[] types = new Class[a];
        for (int i = 0; i < a; ++i) {
            types[i] = ReflectionUtil.getPrimitiveType(objects[i].getClass());
        }
        return types;
    }

    private static Class<?>[] toPrimitiveTypeArray(Class<?>[] classes) {
        int a = classes != null ? classes.length : 0;
        Class[] types = new Class[a];
        for (int i = 0; i < a; ++i) {
            types[i] = ReflectionUtil.getPrimitiveType(classes[i]);
        }
        return types;
    }

    private static boolean equalsTypeArray(Class<?>[] a, Class<?>[] o) {
        if (a.length != o.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(o[i]) || a[i].isAssignableFrom(o[i])) continue;
            return false;
        }
        return true;
    }

    public static Class<?> getClass(String name, DynamicPackage pack, String subPackage) throws Exception {
        return Class.forName((Object)((Object)pack) + (subPackage != null && subPackage.length() > 0 ? "." + subPackage : "") + "." + name);
    }

    public static Class<?> getClass(String name, DynamicPackage pack) {
        try {
            return ReflectionUtil.getClass(name, pack, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class<?> getClass(String name, String namespace) throws Exception {
        return Class.forName(namespace + "." + name);
    }

    public static Object getHandle(Object obj) {
        try {
            return ReflectionUtil.getMethod("getHandle", obj.getClass(), new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getHandle(Player player) {
        try {
            return methodPlayerGetHandle.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        Class<?>[] t = ReflectionUtil.toPrimitiveTypeArray(paramTypes);
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] types = ReflectionUtil.toPrimitiveTypeArray(c.getParameterTypes());
            if (!ReflectionUtil.equalsTypeArray(types, t)) continue;
            return c;
        }
        return null;
    }

    public static Object newInstance(Class<?> clazz, Object ... args) throws Exception {
        return ReflectionUtil.getConstructor(clazz, ReflectionUtil.toPrimitiveTypeArray(args)).newInstance(args);
    }

    public static Object newInstance(String name, DynamicPackage pack, String subPackage, Object ... args) throws Exception {
        return ReflectionUtil.newInstance(ReflectionUtil.getClass(name, pack, subPackage), args);
    }

    public static Object newInstance(String name, DynamicPackage pack, Object ... args) throws Exception {
        return ReflectionUtil.newInstance(ReflectionUtil.getClass(name, pack, null), args);
    }

    public static Method getMethod(String name, Class<?> clazz, Class<?> ... paramTypes) {
        Class<?>[] t = ReflectionUtil.toPrimitiveTypeArray(paramTypes);
        for (Method m : clazz.getMethods()) {
            Class<?>[] types = ReflectionUtil.toPrimitiveTypeArray(m.getParameterTypes());
            if (!m.getName().equals(name) || !ReflectionUtil.equalsTypeArray(types, t)) continue;
            return m;
        }
        return null;
    }

    public static Object invokeMethod(String name, Class<?> clazz, Object obj, Object ... args) throws Exception {
        return ReflectionUtil.getMethod(name, clazz, ReflectionUtil.toPrimitiveTypeArray(args)).invoke(obj, args);
    }

    public static Field getField(String name, Class<?> clazz) throws Exception {
        return clazz.getDeclaredField(name);
    }

    public static Object getValue(String name, Object obj) throws Exception {
        Field f = ReflectionUtil.getField(name, obj.getClass());
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        return f.get(obj);
    }

    public static Object getValueFromClass(String name, Object obj, Class<?> clazz) throws Exception {
        Field f = ReflectionUtil.getField(name, clazz);
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        return f.get(obj);
    }

    public static Object getValue(String name, Class<?> clazz) throws Exception {
        Field f = ReflectionUtil.getField(name, clazz);
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        return f.get(clazz);
    }

    public static void setValue(Object obj, FieldEntry entry) throws Exception {
        Field f = ReflectionUtil.getField(entry.getKey(), obj.getClass());
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        f.set(obj, entry.getValue());
    }

    public static void setValue(String name, Object value, Object obj) throws Exception {
        Field f = ReflectionUtil.getField(name, obj.getClass());
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        f.set(obj, value);
    }

    public static void setFinalValue(String name, Object value, Object obj) throws Exception {
        Field f = obj.getClass().getDeclaredField(name);
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        f.set(obj, value);
    }

    public static void setValues(Object obj, FieldEntry ... entrys) throws Exception {
        for (FieldEntry f : entrys) {
            ReflectionUtil.setValue(obj, f);
        }
    }

    public static String getVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String version = name.substring(name.lastIndexOf(46) + 1) + ".";
        return version;
    }

    public static Class<?> getNMSClass(String className) {
        String fullName = "net.minecraft.server." + ReflectionUtil.getVersion() + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazz;
    }

    public static Class<?> getOBCClass(String className) {
        String fullName = "org.bukkit.craftbukkit." + ReflectionUtil.getVersion() + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazz;
    }

    public static Class<?> getNMSClassWithException(String className) throws Exception {
        String fullName = "net.minecraft.server." + ReflectionUtil.getVersion() + className;
        Class<?> clazz = Class.forName(fullName);
        return clazz;
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name) || args.length != 0 && !ReflectionUtil.ClassListEqual(args, m.getParameterTypes())) continue;
            m.setAccessible(true);
            return m;
        }
        return null;
    }

    public static Field setAccessible(Field f) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        return f;
    }

    public static Method setAccessible(Method m) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        m.setAccessible(true);
        return m;
    }

    public static boolean ClassListEqual(Class<?>[] l1, Class<?>[] l2) {
        boolean equal = true;
        if (l1.length != l2.length) {
            return false;
        }
        for (int i = 0; i < l1.length; ++i) {
            if (l1[i] == l2[i]) continue;
            equal = false;
            break;
        }
        return equal;
    }

    static {
        CORRESPONDING_TYPES.put(Byte.class, Byte.TYPE);
        CORRESPONDING_TYPES.put(Short.class, Short.TYPE);
        CORRESPONDING_TYPES.put(Integer.class, Integer.TYPE);
        CORRESPONDING_TYPES.put(Long.class, Long.TYPE);
        CORRESPONDING_TYPES.put(Character.class, Character.TYPE);
        CORRESPONDING_TYPES.put(Float.class, Float.TYPE);
        CORRESPONDING_TYPES.put(Double.class, Double.TYPE);
        CORRESPONDING_TYPES.put(Boolean.class, Boolean.TYPE);
    }

    public static class FieldEntry {
        String key;
        Object value;

        public FieldEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static enum DynamicPackage {
        MINECRAFT_SERVER{

            public String toString() {
                return "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            }
        }
        ,
        CRAFTBUKKIT{

            public String toString() {
                return Bukkit.getServer().getClass().getPackage().getName();
            }
        };

    }
}

