/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.updater;

import be.maximvdw.mvdwupdater.MVdWUpdater;
import be.maximvdw.mvdwupdater.spigotsite.api.resource.Resource;
import be.maximvdw.mvdwupdater.spigotsite.api.user.User;
import be.maximvdw.placeholderapi.internal.ui.SendConsole;
import be.maximvdw.placeholderapi.internal.utils.bukkit.Version;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MVdWUpdaterHook {
    private static boolean updated = false;

    public MVdWUpdaterHook(Plugin plugin, int resourceId) {
        try {
            MVdWUpdater updater = (MVdWUpdater)Bukkit.getPluginManager().getPlugin("MVdWUpdater");
            SendConsole.info("Hooked into MVdWUpdater!");
            SendConsole.info("Checking for new updates for: " + plugin.getName() + " ...");
            Version currentPluginVersion = new Version(plugin.getDescription().getVersion());
            Version newPluginVersion = new Version(updater.getResourceVersionString(resourceId));
            if (currentPluginVersion.compare(newPluginVersion) == 1) {
                SendConsole.info("An update for '" + plugin.getName() + "' is available");
                if (currentPluginVersion.getMajor() != newPluginVersion.getMajor()) {
                    SendConsole.info("Update is a major update! Manual updating is required!");
                    return;
                }
                SendConsole.info("Getting download link ...");
                Resource premiumResource = updater.getSpigotSiteAPI().getResourceManager().getResourceById(resourceId, (User)updater.getSpigotUser());
                File pluginFile = null;
                try {
                    pluginFile = new File(URLDecoder.decode(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                File outputFile = null;
                try {
                    outputFile = new File(Bukkit.getUpdateFolderFile(), pluginFile.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pluginFile != null && outputFile != null) {
                    SendConsole.info("Downloading '" + plugin.getName() + "' ...");
                    premiumResource.downloadResource((User)updater.getSpigotUser(), outputFile);
                    SendConsole.info("An new update for " + plugin.getName() + " is ready to be installed on next restart!");
                }
            }
            this.setUpdated(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isUpdated() {
        return updated;
    }

    public void setUpdated(boolean updated) {
        MVdWUpdaterHook.updated = updated;
    }
}

