/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.storage;

import be.maximvdw.placeholderapi.internal.storage.YamlBuilder;
import be.maximvdw.placeholderapi.internal.storage.YamlPart;
import java.util.ArrayList;
import java.util.List;

public class YamlSection
extends YamlPart {
    private List<YamlPart> parts = new ArrayList<YamlPart>();

    public YamlSection addPart(YamlPart part) {
        part.setParent(this);
        this.parts.add(part);
        return this;
    }

    public YamlSection addPart(String comment) {
        this.addPart(new YamlBuilder.YamlCommentPart(comment));
        return this;
    }

    public YamlSection addEmptyPart() {
        this.addPart(new YamlBuilder.YamlEmptyPart());
        return this;
    }

    public YamlSection addPart(String key, Object value) {
        this.addPart(new YamlBuilder.YamlKeyValuePart(key, value));
        return this;
    }

    public YamlSection addSection(String section) {
        YamlBuilder.YamlSectionPart sectionPart = new YamlBuilder.YamlSectionPart(section);
        sectionPart.setParent(this);
        this.addPart(sectionPart);
        return sectionPart;
    }

    public YamlSection comment(String comment) {
        this.addPart(comment);
        return this;
    }

    public YamlBuilder.YamlStringListPart list(String name) {
        YamlBuilder.YamlStringListPart list = new YamlBuilder.YamlStringListPart(name);
        this.addPart(list);
        return list;
    }

    public Object getValue(String path) {
        String[] keys = path.split(".");
        if (keys.length == 0) {
            return null;
        }
        for (YamlPart part : this.getParts()) {
            if (part instanceof YamlBuilder.YamlSectionPart) {
                if (keys.length > 1) {
                    String newPath = keys[1];
                    for (int i = 2; i < keys.length; ++i) {
                        newPath = newPath + "." + keys[i];
                    }
                    return this.getValue(newPath);
                }
                return null;
            }
            if (!(part instanceof YamlBuilder.YamlKeyValuePart) || keys.length != 1 || !((YamlBuilder.YamlKeyValuePart)part).getKey().equalsIgnoreCase(keys[0])) continue;
            return ((YamlBuilder.YamlKeyValuePart)part).getValue();
        }
        return null;
    }

    public boolean hasParts() {
        return this.parts.size() > 0;
    }

    public List<YamlPart> getParts() {
        return this.parts;
    }

    public void setParts(List<YamlPart> parts) {
        this.parts = parts;
    }

    public String toString() {
        String result = "";
        for (YamlPart part : this.getParts()) {
            result = result + part.toString() + System.getProperty("line.separator");
        }
        return result;
    }

    public String toCode() {
        String code = "";
        return code;
    }
}

