/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.storage;

import be.maximvdw.placeholderapi.internal.storage.YamlPart;
import be.maximvdw.placeholderapi.internal.storage.YamlSection;
import be.maximvdw.placeholderapi.internal.utils.NumberUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlBuilder
extends YamlSection {
    private int idx = 0;

    public YamlBuilder() {
    }

    public YamlBuilder(String config, int indentSpaces) {
        try (BufferedReader br = new BufferedReader(new StringReader(config));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            for (int i = this.idx; i < lines.size(); ++i) {
                YamlPart part = this.readPart(null, lines, 0, indentSpaces);
                if (part == null) continue;
                this.addPart(part);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YamlPart readPart(YamlSection parent, List<String> lines, int level, int indentSpaces) throws IOException {
        if (this.idx >= lines.size()) {
            return parent;
        }
        String comment = null;
        String line = lines.get(this.idx);
        if (line.contains("#")) {
            comment = line.substring(line.indexOf("#", 0) + 1);
            line = line.substring(0, line.indexOf("#", 0));
        }
        String tabCheck = "";
        for (int i = 0; i < level; ++i) {
            tabCheck = tabCheck + "  ";
        }
        if (line.trim().equals("") && comment != null) {
            if (!line.startsWith(tabCheck)) {
                return parent;
            }
            if (parent == null) {
                ++this.idx;
                return new YamlCommentPart(comment);
            }
            parent.addPart(comment);
            ++this.idx;
            return this.readPart(parent, lines, level, indentSpaces);
        }
        if (line.trim().equals("")) {
            if (parent == null) {
                ++this.idx;
                return new YamlEmptyPart();
            }
            parent.addEmptyPart();
            ++this.idx;
            return this.readPart(parent, lines, level, indentSpaces);
        }
        if (line.trim().startsWith("-")) {
            YamlStringListPart newParent = new YamlStringListPart(((YamlSectionPart)parent).getKey());
            return this.readList(newParent, lines);
        }
        if (line.contains(":")) {
            if (!line.startsWith(tabCheck)) {
                return parent;
            }
            if (line.trim().endsWith(":")) {
                YamlSectionPart newParent = new YamlSectionPart(line.trim().substring(0, line.trim().length() - 1));
                if (parent == null) {
                    ++this.idx;
                    return this.readPart(newParent, lines, level + 1, indentSpaces);
                }
                ++this.idx;
                YamlPart part = this.readPart(newParent, lines, level + 1, indentSpaces);
                if (part != null) {
                    parent.addPart(part);
                }
                return this.readPart(parent, lines, level, indentSpaces);
            }
            String key = line.trim().substring(0, line.trim().indexOf(":", 0));
            String value = line.trim().substring(key.length() + 1).trim();
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
                if (parent == null) {
                    ++this.idx;
                    return new YamlKeyValuePart(key, value);
                }
                parent.addPart(key, value);
                ++this.idx;
                return this.readPart(parent, lines, level, indentSpaces);
            }
            if (value.equals("true") || value.equals("false")) {
                boolean valueBool = Boolean.valueOf(value);
                if (parent == null) {
                    ++this.idx;
                    return new YamlKeyValuePart(key, valueBool);
                }
                parent.addPart(key, valueBool);
                ++this.idx;
                return this.readPart(parent, lines, level, indentSpaces);
            }
            if (NumberUtils.isInteger(value)) {
                if (parent == null) {
                    ++this.idx;
                    return new YamlKeyValuePart(key, Integer.parseInt(value));
                }
                parent.addPart(key, Integer.parseInt(value));
                ++this.idx;
                return this.readPart(parent, lines, level, indentSpaces);
            }
            if (NumberUtils.isNumber(value)) {
                if (parent == null) {
                    ++this.idx;
                    return new YamlKeyValuePart(key, Double.parseDouble(value));
                }
                parent.addPart(key, Double.parseDouble(value));
                ++this.idx;
                return this.readPart(parent, lines, level, indentSpaces);
            }
        }
        return new YamlEmptyPart();
    }

    private YamlStringListPart readList(YamlStringListPart list, List<String> lines) throws IOException {
        if (this.idx >= lines.size()) {
            return list;
        }
        String line = lines.get(this.idx);
        if (line.trim().startsWith("-")) {
            String item = line.trim().substring(1).trim().substring(1);
            item = item.substring(0, item.length() - 1);
            list.addItem(item);
            ++this.idx;
            return this.readList(list, lines);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToFile(File file) {
        FileOutputStream fop = null;
        try {
            fop = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] contentInBytes = this.toString().getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static String sanitize(String input) {
        String output = input;
        output = output.replace("\"", "\\\"");
        return output;
    }

    public static class YamlSectionPart
    extends YamlSection {
        private String key = "";

        public YamlSectionPart(String key) {
            this.setKey(key);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public String toString() {
            String result = this.getKey() + ":" + System.getProperty("line.separator");
            for (YamlPart part : this.getParts()) {
                String[] lines;
                for (String line : lines = part.toString().split(System.getProperty("line.separator"))) {
                    result = result + "  " + line + System.getProperty("line.separator");
                }
            }
            return result;
        }
    }

    public static class YamlStringListPart
    extends YamlPart {
        private String key = "";
        private List<String> items = new ArrayList<String>();

        public YamlStringListPart(String key) {
            this.setKey(key);
        }

        public YamlStringListPart addItem(String item) {
            this.items.add(item);
            return this;
        }

        public List<String> getItems() {
            return this.items;
        }

        public void setItems(List<String> items) {
            this.items = items;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void loadConfig(String path, YamlConfiguration config) {
            this.setItems(config.getStringList(path.equals("") ? this.getKey() : path + "." + this.getKey()));
        }

        public void loadNewConfig(String path, String key, YamlConfiguration config) {
            this.setKey(key);
            this.setItems(config.getStringList(path.equals("") ? this.getKey() : path + "." + this.getKey()));
        }

        public String toString() {
            String result = this.getKey() + ": ";
            if (this.getItems().size() == 0) {
                result = result + "[]" + System.getProperty("line.separator");
            } else {
                result = result + System.getProperty("line.separator");
                for (String item : this.getItems()) {
                    result = result + "- \"" + YamlBuilder.sanitize(item) + "\"" + System.getProperty("line.separator");
                }
            }
            return result;
        }
    }

    public static class YamlEmptyPart
    extends YamlPart {
        public String toString() {
            return "";
        }
    }

    public static class YamlIntegerPart
    extends YamlKeyValuePart {
        public YamlIntegerPart(String key, int value) {
            super(key, value);
        }
    }

    public static class YamlStringPart
    extends YamlKeyValuePart {
        public YamlStringPart(String key, String value) {
            super(key, value);
        }

        @Override
        public String toString() {
            return this.getKey() + ": \"" + YamlBuilder.sanitize(this.getValue().toString()) + "\"";
        }
    }

    public static class YamlKeyValuePart
    extends YamlPart {
        private String key = "";
        private Object value = "";

        public YamlKeyValuePart(String key, Object value) {
            this.setKey(key);
            this.setValue(value);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            if (this.value instanceof String) {
                return new YamlStringPart(this.key, this.value.toString()).toString();
            }
            return this.getKey() + ": " + this.value;
        }

        public void loadConfig(String path, YamlConfiguration config) {
            this.setValue(config.get(path.equals("") ? this.getKey() : path + "." + this.getKey()));
        }

        public void loadNewConfig(String path, String key, YamlConfiguration config) {
            this.setValue(config.get(path.equals("") ? this.getKey() : path + "." + key));
            this.setKey(key);
        }
    }

    public static class YamlCommentPart
    extends YamlPart {
        private String comment = "";

        public YamlCommentPart(String comment) {
            this.setComment(comment);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String toString() {
            return "#" + this.comment;
        }
    }
}

