/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal;

import be.maximvdw.placeholderapi.PlaceholderReplaceEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public abstract class PlaceholderReplacer<T> {
    private String description = "";
    private boolean online = true;
    private boolean requiresPlayer = false;
    protected Object[] args = null;
    private Class<T> returnType = null;
    private DataType dataType = DataType.NORMAL;
    private T defaultOutput = null;
    private String defaultTrueOutput = null;
    private String defaultFalseOutput = null;

    public PlaceholderReplacer(Class<T> type) {
        this.returnType = type;
    }

    public PlaceholderReplacer(Class<T> type, Object ... args) {
        this.returnType = type;
        this.args = args;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public T getResult(PlaceholderReplaceEvent event) {
        return this.getResult(event.getPlaceholder(), event.getOfflinePlayer());
    }

    @Deprecated
    public T getResult(String placeholder, OfflinePlayer player) {
        PlaceholderReplaceEvent replaceEvent = new PlaceholderReplaceEvent(player, placeholder);
        return this.getResult(replaceEvent);
    }

    @Deprecated
    public T getResult(String placeholder, Player player) {
        PlaceholderReplaceEvent replaceEvent = new PlaceholderReplaceEvent((OfflinePlayer)player, placeholder);
        return this.getResult(replaceEvent);
    }

    public Object[] getArguments() {
        return this.args;
    }

    public boolean isPlayerRequired() {
        return this.requiresPlayer;
    }

    public void setRequiresPlayer(boolean requiresPlayer) {
        this.requiresPlayer = requiresPlayer;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public PlaceholderReplacer<T> setDataType(DataType type) {
        this.dataType = type;
        return this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public T getDefaultOutput() {
        return this.defaultOutput;
    }

    public PlaceholderReplacer<T> setDefaultOutput(T defaultOutput) {
        this.defaultOutput = defaultOutput;
        return this;
    }

    public String getDefaultTrueOutput() {
        return this.defaultTrueOutput;
    }

    public PlaceholderReplacer<T> setDefaultTrueOutput(String defaultTrueOutput) {
        this.defaultTrueOutput = defaultTrueOutput;
        return this;
    }

    public String getDefaultFalseOutput() {
        return this.defaultFalseOutput;
    }

    public PlaceholderReplacer<T> setDefaultFalseOutput(String defaultFalseOutput) {
        this.defaultFalseOutput = defaultFalseOutput;
        return this;
    }

    public static enum DataType {
        NORMAL,
        BOOLEAN,
        UNIXTIME;

    }
}

