/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal;

import be.maximvdw.placeholderapi.internal.OnlinePlaceholderReplacer;
import be.maximvdw.placeholderapi.internal.PlaceholderConversion;
import be.maximvdw.placeholderapi.internal.PlaceholderReplacer;
import be.maximvdw.placeholderapi.internal.annotations.ModuleActionName;
import be.maximvdw.placeholderapi.internal.annotations.ModuleAuthor;
import be.maximvdw.placeholderapi.internal.annotations.ModuleConstraint;
import be.maximvdw.placeholderapi.internal.annotations.ModuleConstraints;
import be.maximvdw.placeholderapi.internal.annotations.ModuleDescription;
import be.maximvdw.placeholderapi.internal.annotations.ModuleName;
import be.maximvdw.placeholderapi.internal.annotations.ModulePermalink;
import be.maximvdw.placeholderapi.internal.annotations.ModuleVersion;
import be.maximvdw.placeholderapi.internal.storage.YamlBuilder;
import be.maximvdw.placeholderapi.internal.storage.YamlStorage;
import java.io.File;
import java.io.InvalidClassException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class PlaceholderPack {
    private String id = "";
    private String actionName = "";
    private String author = "";
    private String version = "";
    private boolean module = false;
    private File jarFile = null;
    private Map<String, PlaceholderReplacer<?>> placeholders = new ConcurrentHashMap();
    protected Plugin plugin = null;
    private YamlStorage storage = null;
    private YamlBuilder configBuilder = null;
    private String name = "";
    private List<ModuleConstraint> placeholderConditions = new ArrayList<ModuleConstraint>();
    private boolean enabled = true;
    private boolean actionPlaceholder = false;
    private boolean containsWildcards = false;
    private String description = "";
    private String pluginURL = "";
    private int configVersion = 1;

    public PlaceholderPack(Plugin plugin, int version) {
        this.plugin = plugin;
        this.setConfigVersion(version);
        Class<PlaceholderPack> componentClass = this.getClass().asSubclass(PlaceholderPack.class);
        Annotation[] annotations = componentClass.getAnnotations();
        if (annotations.length == 0) {
            new InvalidClassException("Placeholder pack does not contain annotation information!").printStackTrace();
            return;
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof ModuleConstraint) {
                this.addCondition((ModuleConstraint)annotation);
                continue;
            }
            if (annotation instanceof ModuleAuthor) {
                this.setAuthor(((ModuleAuthor)annotation).value());
                continue;
            }
            if (annotation instanceof ModuleVersion) {
                this.setVersion(((ModuleVersion)annotation).value());
                continue;
            }
            if (annotation instanceof ModuleConstraints) {
                ModuleConstraint[] subConstraints;
                for (ModuleConstraint subConstraint : subConstraints = ((ModuleConstraints)annotation).value()) {
                    this.addCondition(subConstraint);
                }
                continue;
            }
            if (annotation instanceof ModuleName) {
                this.name = ((ModuleName)annotation).value().toLowerCase();
                if (!this.actionName.equals("")) continue;
                this.actionName = this.name;
                continue;
            }
            if (annotation instanceof ModuleActionName) {
                this.actionName = ((ModuleActionName)annotation).value().toLowerCase();
                if (!this.name.equals("")) continue;
                this.name = this.actionName;
                continue;
            }
            if (annotation instanceof ModuleDescription) {
                this.setDescription(((ModuleDescription)annotation).value());
                continue;
            }
            if (!(annotation instanceof ModulePermalink)) continue;
            this.setPluginURL(((ModulePermalink)annotation).value());
        }
    }

    public PlaceholderPack() {
        this(null, 1);
    }

    public abstract void onDisable();

    public abstract void onDelete();

    public abstract void onEnable();

    public YamlConfiguration getConfig() {
        if (this.storage == null) {
            return null;
        }
        return this.storage.getConfig();
    }

    public YamlStorage getStorage() {
        return this.storage;
    }

    public void setStorage(YamlStorage storage) {
        this.storage = storage;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public PlaceholderReplacer<?> getPlaceholderReplacer(String placeholder) {
        if (this.placeholders.containsKey(placeholder.toLowerCase())) {
            return this.placeholders.get(placeholder.toLowerCase());
        }
        return null;
    }

    public Set<String> getOfflinePlaceholder() {
        HashSet<String> placeholdersList = new HashSet<String>();
        for (String placeholder : this.getPlaceholder()) {
            if (!this.placeholders.containsKey(placeholder.toLowerCase()) || this.placeholders.get(placeholder.toLowerCase()).isOnline()) continue;
            placeholdersList.add(placeholder);
        }
        return placeholdersList;
    }

    public Set<String> getOnlinePlaceholder() {
        HashSet<String> placeholdersList = new HashSet<String>();
        for (String placeholder : this.getPlaceholder()) {
            if (!this.placeholders.containsKey(placeholder.toLowerCase()) || !this.placeholders.get(placeholder.toLowerCase()).isOnline()) continue;
            placeholdersList.add(placeholder);
        }
        return placeholdersList;
    }

    public Set<String> getPlaceholder() {
        return this.placeholders.keySet();
    }

    public Map<String, String> getPlaceholderDescriptions() {
        HashMap<String, String> placeholdersList = new HashMap<String, String>();
        for (String placeholder : this.placeholders.keySet()) {
            String description = this.placeholders.get(placeholder).getDescription();
            placeholdersList.put(placeholder, description);
        }
        return placeholdersList;
    }

    private PlaceholderPack addCondition(ModuleConstraint condition) {
        this.placeholderConditions.add(condition);
        return this;
    }

    public PlaceholderPack addPlaceholder(String placeholder, String description, OnlinePlaceholderReplacer<?> replacer) {
        return this.addPlaceholder(placeholder, description, (PlaceholderReplacer<?>)replacer);
    }

    public PlaceholderPack addPlaceholder(String placeholder, String description, PlaceholderReplacer<?> replacer) {
        replacer.setDescription(description);
        replacer.setOnline(true);
        replacer.setRequiresPlayer(true);
        if (replacer.getReturnType().equals(Location.class)) {
            PlaceholderConversion.convertOnlineLocationPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(OfflinePlayer.class)) {
            PlaceholderConversion.convertOnlineOfflinePlayerPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(ItemStack.class)) {
            PlaceholderConversion.convertOnlineItemPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(String[].class)) {
            PlaceholderConversion.convertOnlineStringListPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Integer[].class)) {
            PlaceholderConversion.convertOnlineIntegerListPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Boolean[].class)) {
            PlaceholderConversion.convertOnlineBooleanListPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(World.class)) {
            PlaceholderConversion.convertOnlineWorldPlaceholder(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Calendar.class)) {
            PlaceholderConversion.convertOnlineCalendarPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Boolean.class)) {
            PlaceholderConversion.convertOnlineBooleanPlaceholders(this, placeholder, description, replacer);
            return this;
        }
        if (!placeholder.startsWith("{")) {
            placeholder = "{" + placeholder;
        }
        if (!placeholder.endsWith("}")) {
            placeholder = placeholder + "}";
        }
        this.placeholders.put(placeholder.toLowerCase(), replacer);
        if (placeholder.contains("*")) {
            this.setContainsWildcards(true);
        }
        return this;
    }

    public PlaceholderPack addOfflinePlaceholder(String placeholder, String description, boolean requiresplayer, PlaceholderReplacer<?> replacer) {
        replacer.setDescription(description);
        replacer.setOnline(false);
        replacer.setRequiresPlayer(requiresplayer);
        if (replacer.getReturnType().equals(Location.class)) {
            PlaceholderConversion.convertOfflineLocationPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(OfflinePlayer.class)) {
            PlaceholderConversion.convertOfflineOfflinePlayerPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(ItemStack.class)) {
            PlaceholderConversion.convertOfflineItemPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(String[].class)) {
            PlaceholderConversion.convertOfflineStringListPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Integer[].class)) {
            PlaceholderConversion.convertOfflineIntegerListPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Boolean[].class)) {
            PlaceholderConversion.convertOfflineBooleanListPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(World.class)) {
            PlaceholderConversion.convertOfflineWorldPlaceholder(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Calendar.class)) {
            PlaceholderConversion.convertOfflineCalendarPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (replacer.getReturnType().equals(Boolean.class)) {
            PlaceholderConversion.convertOfflineBooleanPlaceholders(this, placeholder, description, requiresplayer, replacer);
            return this;
        }
        if (!placeholder.startsWith("{")) {
            placeholder = "{" + placeholder;
        }
        if (!placeholder.endsWith("}")) {
            placeholder = placeholder + "}";
        }
        this.placeholders.put(placeholder.toLowerCase(), replacer);
        if (placeholder.contains("*")) {
            this.setContainsWildcards(true);
        }
        return this;
    }

    public void generateConfig() {
        if (this.getConfigBuilder() != null) {
            return;
        }
        this.configBuilder = new YamlBuilder();
        this.getConfigBuilder().addPart("# --------------------------------------- ##");
        this.getConfigBuilder().addPart("# " + this.getDescription() + " Placeholders");
        if (!this.getPluginURL().equals("")) {
            this.getConfigBuilder().addPart("# " + this.getPluginURL());
        }
        this.getConfigBuilder().addPart("# About: This configuration allows you to");
        this.getConfigBuilder().addPart("#        configure what certain placeholders return.");
        this.getConfigBuilder().addPart("# --------------------------------------- ##");
        this.getConfigBuilder().addEmptyPart();
        this.getConfigBuilder().addPart(" DO NOT EDIT THE CONFIG VERSION");
        this.getConfigBuilder().addPart("config", this.getConfigVersion());
        this.getConfigBuilder().addEmptyPart();
        this.getConfigBuilder().addPart(" Enable/Disable the placeholder group");
        this.getConfigBuilder().addPart(" Placeholder groups will not be loaded into the memory");
        this.getConfigBuilder().addPart(" when not used.");
        this.getConfigBuilder().addPart("enabled", true);
        this.getConfigBuilder().addEmptyPart();
        for (Map.Entry<String, PlaceholderReplacer<?>> entry : this.placeholders.entrySet()) {
            YamlBuilder.YamlSectionPart placeholderSection;
            String placeholderString = entry.getKey().replace("{", "").replace("}", "").replace("*", "").replace("@", "").replace("#", "").replace(":", "_");
            PlaceholderReplacer<?> replacerVal = entry.getValue();
            if (replacerVal.getDefaultTrueOutput() != null) {
                this.getConfigBuilder().addPart(" Define what the boolean placeholder {" + placeholderString + "} returns");
                placeholderSection = new YamlBuilder.YamlSectionPart(placeholderString);
                if (replacerVal.getDefaultOutput() != null) {
                    placeholderSection.addPart(" Default return value");
                    placeholderSection.addPart("default", replacerVal.getDefaultOutput());
                }
                placeholderSection.addPart(" This will be shown when the placeholder is 'True'");
                placeholderSection.addPart("true", replacerVal.getDefaultTrueOutput() == null ? "True" : replacerVal.getDefaultTrueOutput());
                placeholderSection.addPart(" This will be shown when the placeholder is 'False'");
                placeholderSection.addPart("false", replacerVal.getDefaultFalseOutput() == null ? "False" : replacerVal.getDefaultFalseOutput());
                this.getConfigBuilder().addPart(placeholderSection);
                this.getConfigBuilder().addEmptyPart();
                continue;
            }
            if (replacerVal.getDefaultOutput() == null) continue;
            this.getConfigBuilder().addPart(" Placeholder settings {" + placeholderString + "} returns");
            placeholderSection = new YamlBuilder.YamlSectionPart(placeholderString);
            placeholderSection.addPart(" Default return value");
            placeholderSection.addPart("default", replacerVal.getDefaultOutput());
            this.getConfigBuilder().addPart(placeholderSection);
            this.getConfigBuilder().addEmptyPart();
        }
    }

    public boolean isOffline(String placeholder) {
        return !this.getPlaceholderReplacer(placeholder).isOnline();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removePlaceholder(String placeholder) {
        this.placeholders.remove(placeholder);
    }

    public List<ModuleConstraint> getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isActionPlaceholder() {
        return this.actionPlaceholder;
    }

    public void setActionPlaceholder(boolean actionPlaceholder) {
        this.actionPlaceholder = actionPlaceholder;
    }

    public boolean hasWildcards() {
        return this.containsWildcards;
    }

    public void setContainsWildcards(boolean containsWildcards) {
        this.containsWildcards = containsWildcards;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public String getPluginURL() {
        return this.pluginURL;
    }

    private void setPluginURL(String pluginURL) {
        this.pluginURL = pluginURL;
    }

    public YamlBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    public void setConfigBuilder(YamlBuilder configBuilder) {
        this.configBuilder = configBuilder;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public boolean isModule() {
        return this.module;
    }

    public void setModule(boolean module) {
        this.module = module;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }
}

