/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import gnu.trove.iterator.TByteIterator;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public final class NBTUtils {
    private static final String NEW_LINE = System.lineSeparator();
    private static final char SPACE = ' ';

    private NBTUtils() {
    }

    @Nonnull
    public static String formatNbt(@Nonnull NBTTagCompound nbtTagCompound) {
        ArrayList keyList = new ArrayList(nbtTagCompound.func_150296_c());
        Collections.sort(keyList);
        StringBuilder nbtBuilder = new StringBuilder().append('{');
        Iterator keyIterator = keyList.iterator();
        while (keyIterator.hasNext()) {
            int difference;
            String key = (String)keyIterator.next();
            String formattedBase = NBTUtils.formatNbtBase(nbtTagCompound.func_74781_a(key));
            if (formattedBase == null) continue;
            int lastNewLine = nbtBuilder.lastIndexOf(NEW_LINE);
            int n = difference = lastNewLine == -1 ? nbtBuilder.length() : nbtBuilder.length() - lastNewLine;
            if (difference > 320) {
                if (nbtBuilder.charAt(nbtBuilder.length() - 1) == ' ') {
                    nbtBuilder.deleteCharAt(nbtBuilder.length() - 1);
                }
                nbtBuilder.append(NEW_LINE);
            }
            nbtBuilder.append(key).append(": ").append(formattedBase);
            if (!keyIterator.hasNext()) continue;
            nbtBuilder.append(", ");
        }
        nbtBuilder.append('}');
        return nbtBuilder.toString();
    }

    private static String formatNbtBase(@Nonnull NBTBase nbtBase) {
        if (nbtBase instanceof NBTTagCompound) {
            return NBTUtils.formatNbt((NBTTagCompound)nbtBase);
        }
        if (nbtBase instanceof NBTTagString) {
            return "\"" + ((NBTTagString)nbtBase).func_150285_a_() + "\"";
        }
        if (nbtBase instanceof NBTTagFloat) {
            return Float.toString(((NBTTagFloat)nbtBase).func_150288_h());
        }
        if (nbtBase instanceof NBTTagDouble) {
            return Double.toString(((NBTTagDouble)nbtBase).func_150286_g());
        }
        if (nbtBase instanceof NBTPrimitive) {
            return Long.toString(((NBTPrimitive)nbtBase).func_150291_c());
        }
        if (nbtBase instanceof NBTTagByteArray) {
            TByteArrayList byteList = new TByteArrayList(((NBTTagByteArray)nbtBase).func_150292_c());
            StringBuilder byteStringBuilder = new StringBuilder().append('[');
            TByteIterator byteIterator = byteList.iterator();
            while (byteIterator.hasNext()) {
                int difference;
                int lastNewLine = byteStringBuilder.lastIndexOf(NEW_LINE);
                int n = difference = lastNewLine == -1 ? byteStringBuilder.length() : byteStringBuilder.length() - lastNewLine;
                if (difference > 320) {
                    if (byteStringBuilder.charAt(byteStringBuilder.length() - 1) == ' ') {
                        byteStringBuilder.deleteCharAt(byteStringBuilder.length() - 1);
                    }
                    byteStringBuilder.append(NEW_LINE);
                }
                byteStringBuilder.append(byteIterator.next());
                if (!byteIterator.hasNext()) continue;
                byteStringBuilder.append(", ");
            }
            byteStringBuilder.append(']');
            return byteStringBuilder.toString();
        }
        if (nbtBase instanceof NBTTagIntArray) {
            TIntArrayList intList = new TIntArrayList(((NBTTagIntArray)nbtBase).func_150302_c());
            StringBuilder intStringBuilder = new StringBuilder().append('[');
            TIntIterator intIterator = intList.iterator();
            while (intIterator.hasNext()) {
                int difference;
                int lastNewLine = intStringBuilder.lastIndexOf(NEW_LINE);
                int n = difference = lastNewLine == -1 ? intStringBuilder.length() : intStringBuilder.length() - lastNewLine;
                if (difference > 320) {
                    if (intStringBuilder.charAt(intStringBuilder.length() - 1) == ' ') {
                        intStringBuilder.deleteCharAt(intStringBuilder.length() - 1);
                    }
                    intStringBuilder.append(NEW_LINE);
                }
                intStringBuilder.append(Integer.toString(intIterator.next()));
                if (!intIterator.hasNext()) continue;
                intStringBuilder.append(", ");
            }
            intStringBuilder.append(']');
            return intStringBuilder.toString();
        }
        if (nbtBase instanceof NBTTagList) {
            NBTTagList nbtTagList = (NBTTagList)nbtBase;
            StringBuilder nbtListStringBuilder = new StringBuilder().append('[');
            if (nbtTagList.func_74745_c() > 0) {
                Iterator nbtBaseIterator = nbtTagList.iterator();
                while (nbtBaseIterator.hasNext()) {
                    int difference;
                    String fb = NBTUtils.formatNbtBase((NBTBase)nbtBaseIterator.next());
                    if (fb == null) continue;
                    int lastNewLine = nbtListStringBuilder.lastIndexOf(NEW_LINE);
                    int n = difference = lastNewLine == -1 ? nbtListStringBuilder.length() : nbtListStringBuilder.length() - lastNewLine;
                    if (difference > 320) {
                        if (nbtListStringBuilder.charAt(nbtListStringBuilder.length() - 1) == ' ') {
                            nbtListStringBuilder.deleteCharAt(nbtListStringBuilder.length() - 1);
                        }
                        nbtListStringBuilder.append(NEW_LINE);
                    }
                    nbtListStringBuilder.append(fb);
                    if (!nbtBaseIterator.hasNext()) continue;
                    nbtListStringBuilder.append(", ");
                }
            }
            nbtListStringBuilder.append(']');
            return nbtListStringBuilder.toString();
        }
        return null;
    }
}

