/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.tooltip;

import com.google.common.collect.ImmutableList;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.bees.CareerBeeSpecies;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TooltipHandler {
    Class<? extends GuiContainer> guiLyzer;

    public void init() {
        try {
            this.guiLyzer = Class.forName("forestry.core.gui.GuiAlyzer");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltipAdd(@Nonnull ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.func_190926_b()) {
            EnumBeeType type = BeeManager.beeRoot.getType(itemStack);
            IBee member = BeeManager.beeRoot.getMember(itemStack);
            if (type != null && member != null) {
                if (BeeMod.deobf && "careerbees".equals(member.getGenome().getPrimary().getModID())) {
                    event.getToolTip().add("CareerBee");
                }
                if (type == EnumBeeType.DRONE && member.getGenome().getPrimary() == CareerBeeSpecies.STUDENT.get() && member.getGenome().getSecondary() == CareerBeeSpecies.STUDENT.get()) {
                    event.getToolTip().add(I18n.func_74838_a((String)"careerbees.message.student.bee"));
                }
            }
        }
    }

    @SubscribeEvent
    public void drawTooltip(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        GuiScreen gui = event.getGui();
        if (this.guiLyzer.isInstance(gui)) {
            GuiContainer container = this.guiLyzer.cast(gui);
            NonNullList inventory = container.field_147002_h.func_75138_a();
            if (inventory.size() >= 3) {
                IAllele effect;
                ItemStack itemStack = (ItemStack)inventory.get(inventory.size() - 5);
                IBee bee = BeeManager.beeRoot.getMember(itemStack);
                if (bee == null) {
                    return;
                }
                int x = event.getMouseX() - container.getGuiLeft();
                int y = event.getMouseY() - container.getGuiTop();
                int dy = 132;
                IBeeGenome genome = bee.getGenome();
                if (x > 90 && x < 155 && y >= dy && y < dy + 12) {
                    effect = genome.getChromosomes()[EnumBeeChromosome.EFFECT.ordinal()].getPrimaryAllele();
                    this.addTooltip(event, container, effect, genome);
                }
                if (x > 155 && x < 220 && y >= dy && y < dy + 12) {
                    effect = genome.getChromosomes()[EnumBeeChromosome.EFFECT.ordinal()].getSecondaryAllele();
                    this.addTooltip(event, container, effect, genome);
                }
            }
        }
    }

    private void addTooltip(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event, @Nonnull GuiContainer container, @Nonnull IAllele effect, @Nonnull IBeeGenome genome) {
        String key = effect.getUnlocalizedName() + ".desc";
        if (net.minecraft.client.resources.I18n.func_188566_a((String)key)) {
            Set<IAlleleBeeSpecies> validSpecies;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            ImmutableList list = effect instanceof EffectBase && !((EffectBase)effect).isValidSpecies(genome) ? ((validSpecies = ((EffectBase)effect).validSpecies).size() == 0 ? ImmutableList.of((Object)net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])new Object[0])) : ImmutableList.of((Object)net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])new Object[0]), (Object)(TextFormatting.RED.toString() + TextFormatting.BOLD.toString() + Lang.translateArgs("Only the bee species, %s, can use this effect!", validSpecies.stream().map(IAllele::getAlleleName).map(s -> '\"' + s + '\"').collect(Collectors.joining(",")))))) : ImmutableList.of((Object)net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])new Object[0]));
            GuiUtils.drawHoveringText((List)list, (int)event.getMouseX(), (int)event.getMouseY(), (int)container.field_146294_l, (int)container.field_146295_m, (int)-1, (FontRenderer)fontRenderer);
        }
    }
}

