/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.definitions.zenclasses;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.objectweb.asm.ClassVisitor;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.EnvironmentScript;
import stanhebben.zenscript.compiler.IEnvironmentClass;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.definitions.ParsedFunction;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.statements.StatementReturn;
import stanhebben.zenscript.symbols.SymbolArgument;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.ZenNativeMember;
import stanhebben.zenscript.util.MethodOutput;

public class ParsedZenClassMethod {
    final ParsedFunction method;
    final String className;

    public ParsedZenClassMethod(ParsedFunction parse, String className) {
        this.method = parse;
        this.className = className;
    }

    public static ParsedZenClassMethod parse(ZenTokener parser, EnvironmentScript classEnvironment, String className) {
        Statement[] statements;
        Token tName = parser.required(1, "identifier expected");
        parser.required(30, "( expected");
        ArrayList<ParsedFunctionArgument> arguments = new ArrayList<ParsedFunctionArgument>();
        if (parser.optional(31) == null) {
            Token argName = parser.required(1, "identifier expected");
            ZenType type = ZenTypeAny.INSTANCE;
            if (parser.optional(120) != null) {
                type = ZenType.read(parser, classEnvironment);
            }
            arguments.add(new ParsedFunctionArgument(argName.getValue(), type));
            while (parser.optional(11) != null) {
                Token argName2 = parser.required(1, "identifier expected");
                ZenType type2 = ZenTypeAny.INSTANCE;
                if (parser.optional(120) != null) {
                    type2 = ZenType.read(parser, classEnvironment);
                }
                arguments.add(new ParsedFunctionArgument(argName2.getValue(), type2));
            }
            parser.required(31, ") expected");
        }
        ZenType type = ZenTypeAny.INSTANCE;
        if (parser.optional(120) != null) {
            type = ZenType.read(parser, classEnvironment);
        }
        parser.required(5, "{ expected");
        if (parser.optional(6) != null) {
            statements = new Statement[]{};
        } else {
            ArrayList<Statement> statementsAL = new ArrayList<Statement>();
            while (parser.optional(6) == null) {
                statementsAL.add(Statement.read(parser, classEnvironment, type));
            }
            statements = statementsAL.toArray(new Statement[statementsAL.size()]);
        }
        return new ParsedZenClassMethod(new ParsedFunction(tName.getPosition(), tName.getValue(), arguments, type, statements), className);
    }

    public void addToMember(ZenNativeMember zenNativeMember) {
        zenNativeMember.addMethod(new ZenClassMethod());
    }

    public void writeAll(ClassVisitor newClass, IEnvironmentClass environmentNewClass) {
        Statement[] statements;
        String description = this.method.getSignature();
        MethodOutput methodOutput = new MethodOutput(newClass, 1, this.method.getName(), description, null, null);
        EnvironmentMethod methodEnvironment = new EnvironmentMethod(methodOutput, environmentNewClass);
        List<ParsedFunctionArgument> arguments = this.method.getArguments();
        int i = 0;
        while (i < arguments.size()) {
            ParsedFunctionArgument argument = arguments.get(i);
            methodEnvironment.putValue(argument.getName(), new SymbolArgument(++i, argument.getType()), this.method.getPosition());
        }
        methodOutput.start();
        for (Statement statement : statements = this.method.getStatements()) {
            statement.compile(methodEnvironment);
        }
        if (this.method.getReturnType() != ZenType.VOID) {
            if (statements.length != 0 && statements[statements.length - 1] instanceof StatementReturn) {
                if (((StatementReturn)statements[statements.length - 1]).getExpression() != null) {
                    this.method.getReturnType().defaultValue(this.method.getPosition()).compile(true, methodEnvironment);
                    methodOutput.returnType(this.method.getReturnType().toASMType());
                }
            } else {
                this.method.getReturnType().defaultValue(this.method.getPosition()).compile(true, methodEnvironment);
                methodOutput.returnType(this.method.getReturnType().toASMType());
            }
        } else if (statements.length == 0 || !(statements[statements.length - 1] instanceof StatementReturn)) {
            methodOutput.ret();
        }
        methodOutput.end();
    }

    public class ZenClassMethod
    implements IJavaMethod {
        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean accepts(int numArguments) {
            return ParsedZenClassMethod.this.method.getArgumentTypes().length == numArguments;
        }

        @Override
        public boolean accepts(IEnvironmentGlobal environment, Expression ... arguments) {
            return this.accepts(arguments.length) && IntStream.range(0, arguments.length).allMatch(i -> arguments[i].getType().canCastImplicit(ParsedZenClassMethod.this.method.getArgumentTypes()[i], environment));
        }

        @Override
        public int getPriority(IEnvironmentGlobal environment, Expression ... arguments) {
            return this.matchesExact(arguments) ? 3 : (this.accepts(environment, arguments) ? 1 : -1);
        }

        private boolean matchesExact(Expression ... arguments) {
            if (!this.accepts(arguments.length)) {
                return false;
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i].getType().toJavaClass() == ParsedZenClassMethod.this.method.getArgumentTypes()[i].toJavaClass()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void invokeVirtual(MethodOutput output) {
            output.invokeVirtual(ParsedZenClassMethod.this.className, ParsedZenClassMethod.this.method.getName(), ParsedZenClassMethod.this.method.getSignature());
        }

        @Override
        public void invokeStatic(MethodOutput output) {
            throw new UnsupportedOperationException("Cannot statically invoke a virtual method");
        }

        @Override
        public ZenType[] getParameterTypes() {
            return ParsedZenClassMethod.this.method.getArgumentTypes();
        }

        @Override
        public ZenType getReturnType() {
            return ParsedZenClassMethod.this.method.getReturnType();
        }

        @Override
        public boolean isVarargs() {
            return false;
        }

        @Override
        public String getErrorDescription() {
            StringBuilder builder = new StringBuilder(ParsedZenClassMethod.this.method.getName()).append("(");
            for (ZenType zenType : ParsedZenClassMethod.this.method.getArgumentTypes()) {
                builder.append(zenType.toString()).append(", ");
            }
            int length = builder.length();
            builder.delete(length - 2, length);
            return builder.append(")").toString();
        }
    }
}

