/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.tileentity;

import com.timwoodcreates.roost.RoostConfig;
import com.timwoodcreates.roost.data.DataChicken;
import com.timwoodcreates.roost.tileentity.TileEntityChickenContainer;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;

public class TileEntityBreeder
extends TileEntityChickenContainer {
    private static final String CHICKEN_0_KEY = "Chicken0";
    private static final String CHICKEN_1_KEY = "Chicken1";
    private static final String COMPLETE_KEY = "Complete";
    private static final String HAS_SEEDS_KEY = "HasSeeds";

    @Override
    protected void spawnChickenDrop() {
        DataChicken left = this.getChickenData(0);
        DataChicken right = this.getChickenData(1);
        if (left != null && right != null) {
            this.putStackInOutput(left.createChildStack(right, this.func_145831_w()));
            this.playSpawnSound();
            this.spawnParticles();
        }
    }

    private void playSpawnSound() {
        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.NEUTRAL, 0.5f, 0.8f);
    }

    private void spawnParticles() {
        this.spawnParticle(-0.1, 0.5, 0.0, 0.2);
        this.spawnParticle(0.5, -0.1, 0.2, 0.0);
        this.spawnParticle(1.1, 0.5, 0.0, 0.2);
        this.spawnParticle(0.5, 1.1, 0.2, 0.0);
    }

    private void spawnParticle(double x, double z, double xOffset, double zOffset) {
        if (this.func_145831_w() instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.func_145831_w();
            worldServer.func_175739_a(EnumParticleTypes.HEART, (double)this.field_174879_c.func_177958_n() + x, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + z, 2, xOffset, 0.2, zOffset, 0.02, new int[0]);
        }
    }

    public void addInfoToTooltip(List<String> tooltip, NBTTagCompound tag) {
        DataChicken chicken;
        if (tag.func_74764_b(CHICKEN_0_KEY)) {
            chicken = DataChicken.getDataFromTooltipNBT(tag.func_74775_l(CHICKEN_0_KEY));
            tooltip.add(chicken.getDisplaySummary());
        }
        if (tag.func_74764_b(CHICKEN_1_KEY)) {
            chicken = DataChicken.getDataFromTooltipNBT(tag.func_74775_l(CHICKEN_1_KEY));
            tooltip.add(chicken.getDisplaySummary());
        }
        if (tag.func_74764_b(COMPLETE_KEY)) {
            tooltip.add(new TextComponentTranslation("container.roost.progress", new Object[]{this.formatProgress(tag.func_74769_h(COMPLETE_KEY))}).func_150254_d());
            if (!tag.func_74767_n(HAS_SEEDS_KEY)) {
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"container.roost.breeder.seedless", (Object[])new Object[0]));
            }
        }
    }

    public void storeInfoForTooltip(NBTTagCompound tag) {
        DataChicken chicken0 = this.getChickenData(0);
        DataChicken chicken1 = this.getChickenData(1);
        if (chicken0 != null) {
            tag.func_74782_a(CHICKEN_0_KEY, (NBTBase)chicken0.buildTooltipNBT());
        }
        if (chicken1 != null) {
            tag.func_74782_a(CHICKEN_1_KEY, (NBTBase)chicken1.buildTooltipNBT());
        }
        if (chicken0 != null && chicken1 != null) {
            tag.func_74780_a(COMPLETE_KEY, this.getProgress());
            tag.func_74757_a(HAS_SEEDS_KEY, this.isFullOfSeeds());
        }
    }

    public String func_70005_c_() {
        return "container.roost.breeder";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public int func_70302_i_() {
        return 6;
    }

    @Override
    public int getSizeChickenInventory() {
        return 2;
    }

    @Override
    protected int requiredSeedsForDrop() {
        return 2;
    }

    @Override
    protected double speedMultiplier() {
        return RoostConfig.breederSpeed;
    }
}

