/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.tweaks;

import com.enderio.core.common.config.AbstractConfigHandler;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.tweaks.BottleFluidCapability;
import com.enderio.core.common.tweaks.InfiniBow;
import com.enderio.core.common.tweaks.SlabRecipes;
import com.enderio.core.common.tweaks.Tweak;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Tweaks {
    private static final Set<Tweak> ingameTweaks = new HashSet<Tweak>();
    private static final Set<Tweak> permanentTweaks = new HashSet<Tweak>();

    public static void loadIngameTweaks() {
        Tweaks.load(ingameTweaks);
    }

    public static void loadNonIngameTweaks() {
        Tweaks.load(permanentTweaks);
    }

    private static void load(Collection<Tweak> tweaks) {
        for (Tweak tweak : tweaks) {
            if (ConfigHandler.instance().addBooleanFor(tweak)) {
                tweak.enable();
                continue;
            }
            tweak.disable();
        }
    }

    static {
        ingameTweaks.add(new Tweak("changeBoatStackSize", "Makes boats stack to 16", AbstractConfigHandler.RestartReqs.NONE){

            @Override
            public void load() {
                Items.field_151124_az.func_77625_d(16);
            }

            @Override
            public void unload() {
                Items.field_151124_az.func_77625_d(1);
            }
        });
        ingameTweaks.add(new Tweak("fixPackedIceTool", "Allows packed ice to be mined with a pickaxe", AbstractConfigHandler.RestartReqs.NONE){

            @Override
            public void load() {
                Blocks.field_150403_cj.setHarvestLevel("pickaxe", 0);
            }

            @Override
            public void unload() {
                Blocks.field_150403_cj.setHarvestLevel(null, -1);
            }
        });
        ingameTweaks.add(new Tweak("fluidContainerBottles", "Makes water bottles normal fluid containers"){

            @Override
            public void load() {
                MinecraftForge.EVENT_BUS.register(BottleFluidCapability.class);
            }

            @Override
            protected void unload() {
                MinecraftForge.EVENT_BUS.unregister(BottleFluidCapability.class);
            }
        });
        ingameTweaks.add(new InfiniBow());
        permanentTweaks.add(new SlabRecipes());
        permanentTweaks.add(new Tweak("bookToPaperRecipe", "Adds shapeless recipe from 1 book to 2 paper"){

            @Override
            public void load() {
                ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(null, new ItemStack(Items.field_151121_aF, 2), new Object[]{Items.field_151122_aG}).setRegistryName("book_to_paper"));
            }
        });
        permanentTweaks.add(new Tweak("shapelessPaperRecipe", "Adds a shapeless recipe for paper"){

            @Override
            public void load() {
                ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(null, new ItemStack(Items.field_151121_aF, 3), new Object[]{Items.field_151120_aE, Items.field_151120_aE, Items.field_151120_aE}).setRegistryName("shapeless_paper"));
            }
        });
    }
}

