/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class TileCraftCrate
extends TileOpenCrate {
    public static final boolean[][] PATTERNS = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {true, true, false, true, true, false, false, false, false}, {true, false, false, true, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false}, {true, false, false, true, false, false, true, false, false}, {true, true, true, false, false, false, false, false, false}, {true, true, false, true, true, false, true, true, false}, {true, true, true, true, true, true, false, false, false}, {true, true, true, true, false, true, true, true, true}};
    private static final String TAG_PATTERN = "pattern";
    public int pattern = -1;
    private int signal = 0;

    @Override
    public int getSizeInventory() {
        return 10;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, true){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot != 9 && !TileCraftCrate.this.isLocked(slot)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    public boolean isLocked(int slot) {
        return this.pattern != -1 && !PATTERNS[this.pattern][slot];
    }

    @Override
    public void func_73660_a() {
        int newSignal;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canEject() && this.isFull() && this.craft(true)) {
            this.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (this.isLocked(newSignal) || !this.itemHandler.getStackInSlot(newSignal).func_190926_b()); ++newSignal) {
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        }
    }

    private boolean craft(boolean fullCheck) {
        if (fullCheck && !this.isFull()) {
            return false;
        }
        InventoryCrafting craft = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || this.isLocked(i) || stack.func_77973_b() == ModItems.manaResource && stack.func_77952_i() == 11) continue;
            craft.func_70299_a(i, stack);
        }
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!recipe.func_77569_a(craft, this.field_145850_b)) continue;
            this.itemHandler.setStackInSlot(9, recipe.func_77572_b(craft));
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                this.itemHandler.setStackInSlot(i, container);
            }
            return true;
        }
        return false;
    }

    boolean isFull() {
        for (int i = 0; i < 9; ++i) {
            if (this.isLocked(i) || !this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                this.eject(stack, false);
            }
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    @Override
    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_PATTERN, this.pattern);
    }

    @Override
    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.pattern = par1nbtTagCompound.func_74762_e(TAG_PATTERN);
    }

    @Override
    public boolean onWanded(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    @Override
    public int getSignal() {
        return this.signal;
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        int lastPattern = this.pattern;
        super.onDataPacket(manager, packet);
        if (this.pattern != lastPattern) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }
}

