/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.net;

import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.latmod.yabba.gui.GuiBarrelConnector;
import com.latmod.yabba.net.YabbaNetHandler;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageBarrelConnector
extends MessageToClient {
    private ITextComponent title;
    private Collection<BarrelInst> barrels;

    public MessageBarrelConnector() {
    }

    public MessageBarrelConnector(ITextComponent t, List<BarrelInst> l) {
        this.title = t;
        this.barrels = l;
    }

    public NetworkWrapper getWrapper() {
        return YabbaNetHandler.NET;
    }

    public void writeData(DataOut data) {
        data.writeTextComponent(this.title);
        data.writeCollection(this.barrels, BarrelInst.SERIALIZER);
    }

    public void readData(DataIn data) {
        this.title = data.readTextComponent();
        this.barrels = data.readCollection(BarrelInst.DESERIALIZER);
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiBarrelConnector(this.title, this.barrels).openGui();
    }

    public static class BarrelInst {
        public static final DataOut.Serializer<BarrelInst> SERIALIZER = (data, object) -> {
            data.writeTextComponent(object.title);
            data.writeTextComponent(object.title2);
            data.writeIcon(object.icon);
            data.writeIcon(object.icon2);
            data.writePos((Vec3i)object.pos);
        };
        public static final DataIn.Deserializer<BarrelInst> DESERIALIZER = data -> {
            BarrelInst inst = new BarrelInst();
            inst.title = data.readTextComponent();
            inst.title2 = data.readTextComponent();
            inst.icon = data.readIcon();
            inst.icon2 = data.readIcon();
            inst.pos = data.readPos();
            return inst;
        };
        public ITextComponent title;
        public ITextComponent title2;
        public Icon icon;
        public Icon icon2;
        public BlockPos pos;
    }
}

