/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.wireless;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio")
public class WirelessChargerController {
    @Nonnull
    public static WirelessChargerController instance = new WirelessChargerController();
    @Nonnull
    private final Map<Integer, Collection<BlockPos>> perWorldChargers = new HashMap<Integer, Collection<BlockPos>>();
    private int changeCount;

    private WirelessChargerController() {
    }

    public void registerCharger(@Nonnull IWirelessCharger charger) {
        this.getChargersForWorld(charger.getworld()).add(charger.getLocation().func_185334_h());
        ++this.changeCount;
    }

    public void deregisterCharger(@Nonnull IWirelessCharger charger) {
        this.getChargersForWorld(charger.getworld()).remove(charger.getLocation());
        ++this.changeCount;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.END || event.player.func_175149_v()) {
            return;
        }
        instance.chargePlayersItems((EntityPlayer)NullHelper.notnullF((Object)event.player, (String)"TickEvent.PlayerTickEvent without player"));
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void getChargers(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Collection<IWirelessCharger> res) {
        Collection<BlockPos> chargers = this.getChargersForWorld(world);
        Iterator<BlockPos> iterator = chargers.iterator();
        while (iterator.hasNext()) {
            IWirelessCharger charger;
            BlockPos chargerPos = iterator.next();
            IWirelessCharger iWirelessCharger = charger = chargerPos != null ? (IWirelessCharger)BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)chargerPos, IWirelessCharger.class) : null;
            if (charger != null) {
                if (!charger.getRange().contains(pos)) continue;
                res.add(charger);
                continue;
            }
            iterator.remove();
            ++this.changeCount;
        }
    }

    public void chargePlayersItems(@Nonnull EntityPlayer player) {
        ArrayList<IWirelessCharger> chargers = new ArrayList<IWirelessCharger>();
        this.getChargers(player.field_70170_p, new BlockPos((Entity)player), chargers);
        if (chargers.isEmpty()) {
            return;
        }
        BlockPos pos = BlockCoord.get((Entity)player);
        for (IWirelessCharger charger : chargers) {
            boolean done;
            if (!charger.isActive() || !charger.getRange().contains(pos) || !(done = this.chargeFromCapBank(player, charger))) continue;
            return;
        }
    }

    private boolean chargeFromCapBank(@Nonnull EntityPlayer player, @Nonnull IWirelessCharger charger) {
        boolean res = charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
        res |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        res |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_184439_c);
        IInventory baubles = BaublesUtil.instance().getBaubles(player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack item = baubles.func_70301_a(i);
                if (!Prep.isValid(item)) continue;
                item = item.func_77946_l();
                if (!charger.chargeItems((NonNullList<ItemStack>)new NNList((Object[])new ItemStack[]{item}))) continue;
                baubles.func_70299_a(i, item);
                res = true;
            }
        }
        if (res) {
            player.field_71069_bz.func_75142_b();
        }
        return res;
    }

    @Nonnull
    private Collection<BlockPos> getChargersForWorld(@Nonnull World world) {
        Collection<BlockPos> res = this.perWorldChargers.get(world.field_73011_w.getDimension());
        if (res == null) {
            res = new HashSet<BlockPos>();
            this.perWorldChargers.put(world.field_73011_w.getDimension(), res);
        }
        return res;
    }
}

