/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.recipes;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.alloy.endergy.AlloyEndergy;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.material.Material;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="enderio")
public class MaterialOredicts {
    static final String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    private static final NNList<String> REGISTERED = new NNList();

    public static void init(FMLInterModComms.IMCEvent event) {
        Material.getActiveMaterials().apply((NNList.Callback)new NNList.Callback<Material>(){

            public void apply(@Nonnull Material material) {
                if (material.hasDependency()) {
                    MaterialOredicts.registerOre(material.getOreDict(), material.getStack());
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerOredict(@Nonnull RegistryEvent.Register<Item> event) {
        Material.getActiveMaterials().apply((NNList.Callback)new NNList.Callback<Material>(){

            public void apply(@Nonnull Material material) {
                if (!material.hasDependency()) {
                    MaterialOredicts.registerOre(material.getOreDict(), material.getStack());
                }
            }
        });
        NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

            public void apply(@Nonnull Alloy alloy) {
                MaterialOredicts.registerOre(alloy.getOreBlock(), alloy.getStackBlock());
                MaterialOredicts.registerOre(alloy.getOreIngot(), alloy.getStackIngot());
                MaterialOredicts.registerOre(alloy.getOreNugget(), alloy.getStackNugget());
                MaterialOredicts.registerOre(alloy.getOreBall(), alloy.getStackBall());
            }
        });
        NNList.of(AlloyEndergy.class).apply((NNList.Callback)new NNList.Callback<AlloyEndergy>(){

            public void apply(@Nonnull AlloyEndergy alloy) {
                MaterialOredicts.registerOre(alloy.getOreBlock(), alloy.getStackBlock());
                MaterialOredicts.registerOre(alloy.getOreIngot(), alloy.getStackIngot());
                MaterialOredicts.registerOre(alloy.getOreNugget(), alloy.getStackNugget());
                MaterialOredicts.registerOre(alloy.getOreBall(), alloy.getStackBall());
            }
        });
        MaterialOredicts.registerOre("blockGlass", new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("blockGlassColorless", new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, EnumDyeColor.WHITE.func_176765_a()));
        MaterialOredicts.registerOre("blockGlassHardened", new ItemStack(FusedQuartzType.FUSED_QUARTZ.getBlock(), 1, Short.MAX_VALUE));
        for (int i = 0; i < dyes.length; ++i) {
            MaterialOredicts.registerOre("blockGlass" + dyes[i], new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, EnumDyeColor.func_176766_a((int)i).func_176765_a()));
            MaterialOredicts.registerOre("blockGlassHardened" + dyes[i], new ItemStack(FusedQuartzType.FUSED_QUARTZ.getBlock(), 1, EnumDyeColor.func_176766_a((int)i).func_176765_a()));
        }
        for (FusedQuartzType type : FusedQuartzType.values()) {
            MaterialOredicts.registerOre(type.getOreDictName(), new ItemStack(type.getBlock(), 1, Short.MAX_VALUE));
        }
        MaterialOredicts.registerOre("itemSkull", new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("itemSkull", new ItemStack(ModObject.blockEndermanSkull.getBlockNN()));
        Things.addAlias((String)Material.DYE_GREEN.getBaseName().toUpperCase(Locale.ENGLISH), (String)(ModObject.itemMaterial.getItemNN().getRegistryName() + ":" + Material.DYE_GREEN.ordinal()));
        Things.addAlias((String)Material.DYE_BROWN.getBaseName().toUpperCase(Locale.ENGLISH), (String)(ModObject.itemMaterial.getItemNN().getRegistryName() + ":" + Material.DYE_BROWN.ordinal()));
        Things.addAlias((String)Material.DYE_BLACK.getBaseName().toUpperCase(Locale.ENGLISH), (String)(ModObject.itemMaterial.getItemNN().getRegistryName() + ":" + Material.DYE_BLACK.ordinal()));
        MaterialOredicts.registerOre("toolHoe", new ItemStack(Items.field_151017_I, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("toolHoe", new ItemStack(Items.field_151019_K, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("toolHoe", new ItemStack(Items.field_151018_J, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("toolHoe", new ItemStack(Items.field_151012_L, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("toolHoe", new ItemStack(Items.field_151013_M, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("egg", new ItemStack(ModObject.item_owl_egg.getItemNN()));
        MaterialOredicts.registerOre("eggOwl", new ItemStack(ModObject.item_owl_egg.getItemNN()));
        MaterialOredicts.registerOre("toolShears", new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("toolShears", new ItemStack(ModObject.itemDarkSteelShears.getItemNN(), 1, Short.MAX_VALUE));
        MaterialOredicts.registerOre("toolTreetap", new ItemStack(ModObject.itemDarkSteelTreetap.getItemNN(), 1, Short.MAX_VALUE));
    }

    public static void registerOre(@Nonnull String name, @Nonnull ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
        REGISTERED.add((Object)name);
    }

    public static void checkOreRegistrations() {
        NNList failed = new NNList();
        for (String name : REGISTERED) {
            if (!OreDictionary.getOres((String)name).isEmpty()) continue;
            failed.add((Object)name);
        }
        if (!failed.isEmpty()) {
            Log.warn("=========================================================================");
            Log.warn("= Dear other mod author, ================================================");
            Log.warn("= while we do not care what is in those oredict entries, our mod is =====");
            Log.warn("= coded to assume that there is at least one item in them. Feel free to =");
            Log.warn("= put in some invisible unobtainable dummy item, but please don't empty =");
            Log.warn("= them completely. ======================================================");
            Log.warn("= Thank you! ============================================================");
            Log.warn("=========================================================================");
            EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL ERROR ==", "=======================================================================", "We registered some items with the Ore Dictionary but they are now gone.", "That means that some other mod has messed with our stuff.", "=======================================================================", "This is NOT a bug in Ender IO.", "=======================================================================", "Find out which mod deletes our items and report this to THEM.", "=======================================================================", "Missing registration(s):", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)failed), "=======================================================================", "", "");
        }
    }
}

