/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.network;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityPoweredMachineEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPowerStorage
extends MessageTileEntity<AbstractCapabilityPoweredMachineEntity> {
    private int storedEnergy;

    public PacketPowerStorage() {
    }

    public PacketPowerStorage(@Nonnull AbstractCapabilityPoweredMachineEntity ent) {
        super((TileEntity)ent);
        this.storedEnergy = ent.getEnergy().getEnergyStored();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.storedEnergy = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketPowerStorage, IMessage> {
        public IMessage onMessage(PacketPowerStorage message, MessageContext ctx) {
            AbstractCapabilityPoweredMachineEntity te = (AbstractCapabilityPoweredMachineEntity)message.getTileEntity(Minecraft.func_71410_x().field_71439_g.field_70170_p);
            if (te != null) {
                te.getEnergy().setEnergyStored(message.storedEnergy);
            }
            return null;
        }
    }
}

