/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.coldfire;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColdFireIgniter
extends Item
implements IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware {
    public static ItemColdFireIgniter create(@Nonnull IModObject modObject) {
        return new ItemColdFireIgniter(modObject);
    }

    protected ItemColdFireIgniter(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos = pos.func_177972_a(side), side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_175623_d(pos)) {
            if ((Integer)DarkSteelConfig.mbPerUse.get() > 0 && !this.drain(stack, (Integer)DarkSteelConfig.mbPerUse.get())) {
                Fluid fluid = this.getFluidType(stack);
                String fluidname = fluid.getLocalizedName(new FluidStack(fluid, 1));
                player.func_145747_a((ITextComponent)Lang.COLD_FIRE_NO_FLUID.toChat(fluidname));
            } else {
                world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                world.func_180501_a(pos, ModObject.blockColdFire.getBlockNN().func_176223_P(), 11);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public Fluid getFluidType(@Nonnull ItemStack container) {
        return (Fluid)DarkSteelConfig.fluidType.get();
    }

    private FluidStack getFluid(@Nonnull ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0) {
            return new FluidStack(this.getFluidType(container), amount);
        }
        return null;
    }

    private int getCapacity(@Nonnull ItemStack container) {
        return (Integer)DarkSteelConfig.mbCapacity.get();
    }

    private int fill(@Nonnull ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != this.getFluidType(container)) {
            return 0;
        }
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        int free = (Integer)DarkSteelConfig.mbCapacity.get() - amount;
        int toFill = Math.min(resource.amount, free);
        if (toFill > 0 && doFill) {
            NbtValue.FLUIDAMOUNT.setInt(container, amount + toFill);
        }
        return toFill;
    }

    private boolean drain(@Nonnull ItemStack container, int toDrain) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (toDrain > amount) {
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - toDrain);
        return true;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(LangFluid.MB(NbtValue.FLUIDAMOUNT.getInt(stack, 0), (Integer)DarkSteelConfig.mbCapacity.get(), this.getFluidType(stack)));
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, 0);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            list.add((Object)stack.func_77946_l());
            NbtValue.FLUIDAMOUNT.setInt(stack, (int)((Integer)DarkSteelConfig.mbCapacity.get()));
            list.add((Object)stack);
        }
    }

    private class CapabilityProvider
    implements ICapabilityProvider,
    IFluidHandlerItem {
        @Nonnull
        protected final ItemStack container;

        private CapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == FluidUtil.getFluidItemCapability();
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == FluidUtil.getFluidItemCapability()) {
                return (T)FluidUtil.getFluidItemCapability().cast((Object)this);
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemColdFireIgniter.this.getFluid(CapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return ItemColdFireIgniter.this.getCapacity(CapabilityProvider.this.container);
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemColdFireIgniter.this.getFluidType(CapabilityProvider.this.container);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemColdFireIgniter.this.fill(this.container, resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }
    }
}

