/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeRoot;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Capacitor;
import crazypants.enderio.base.config.recipes.xml.Grindingball;
import crazypants.enderio.base.config.recipes.xml.Recipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraftforge.fml.common.ProgressManager;

public class Recipes
implements RecipeRoot {
    @Nonnull
    private final List<AbstractConditional> recipes = new ArrayList<AbstractConditional>();

    @Override
    public List<AbstractConditional> getRecipes() {
        return this.recipes;
    }

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        return this;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void register(@Nonnull String recipeName) {
        String prefix = recipeName.isEmpty() ? "" : recipeName + ": ";
        Log.debug("Starting registering XML recipes");
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Recipe", (int)this.recipes.size());
        for (AbstractConditional recipe : this.recipes) {
            bar.step(prefix + recipe.getName());
            recipe.register(prefix + recipe.getName());
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        Log.debug("Done registering XML recipes");
    }

    @Override
    public <T extends RecipeRoot> T addRecipes(RecipeRoot other, RecipeRoot.Overrides overrides) throws InvalidRecipeConfigException {
        if (other instanceof Recipes) {
            if (this.recipes.isEmpty()) {
                return (T)other;
            }
            if (((Recipes)other).recipes.isEmpty()) {
                return (T)this;
            }
            HashMap<String, AbstractConditional> recipeNames = new HashMap<String, AbstractConditional>();
            for (AbstractConditional recipe : this.recipes) {
                recipeNames.put(recipe.getName(), recipe);
            }
            for (AbstractConditional recipe : ((Recipes)other).recipes) {
                if (!recipeNames.containsKey(recipe.getName())) {
                    this.recipes.add(recipe);
                    continue;
                }
                if (overrides == RecipeRoot.Overrides.DENY) {
                    throw new InvalidRecipeConfigException("Duplicate recipe '" + recipe.getName() + "'. A recipe with the same name was already read from " + recipe.getSource());
                }
                if (overrides != RecipeRoot.Overrides.WARN) continue;
                Log.warn("Recipe '" + recipe.getName() + "' from '" + recipe.getSource() + "' is being replaced by a recipe from '" + ((AbstractConditional)recipeNames.get(recipe.getName())).getSource() + "'");
            }
        }
        return (T)this;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("enderio".equals(name)) {
            return true;
        }
        if ("xsi".equals(name)) {
            return true;
        }
        return "schemaLocation".equals(name);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("alias".equals(name)) {
            factory.skip(startElement);
            return true;
        }
        if ("recipe".equals(name)) {
            this.addRecipe(new Recipe(), factory, startElement);
            return true;
        }
        if ("grindingball".equals(name)) {
            this.addRecipe(new Grindingball(), factory, startElement);
            return true;
        }
        if ("capacitor".equals(name)) {
            this.addRecipe(new Capacitor(), factory, startElement);
            return true;
        }
        return false;
    }

    private <T extends AbstractConditional> void addRecipe(T element, StaxFactory factory, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        T recipe = factory.read(element, startElement);
        for (AbstractConditional existingRecipe : this.recipes) {
            if (!existingRecipe.getName().equals(recipe.getName())) continue;
            throw new InvalidRecipeConfigException("Duplicate recipe '" + recipe.getName() + "'. A recipe with the same name was already read from " + existingRecipe.getSource());
        }
        this.recipes.add(recipe);
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (AbstractConditional recipe : this.recipes) {
            recipe.enforceValidity();
        }
    }
}

