/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValueFactory;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;

public class ThingsValue
extends AbstractValue<Things> {
    @Nonnull
    public static final IByteBufAdapter<Things> THINGS = ByteBufAdapters.register((IByteBufAdapter)new IByteBufAdapter<Things>(){

        public void saveValue(@Nonnull ByteBuf buf, @Nonnull Things value) {
            NNList nameList = value.getNameList();
            if (nameList.size() > 127) {
                throw new RuntimeException("Thing too big");
            }
            buf.writeByte(nameList.size());
            for (String string : nameList) {
                ByteBufAdapters.STRING127.saveValue(buf, NullHelper.first((Object[])new String[]{string, ""}));
            }
        }

        public Things readValue(@Nonnull ByteBuf buf) {
            Things result = new Things();
            int len = buf.readByte();
            for (int i = 0; i < len; ++i) {
                result.add((String)ByteBufAdapters.STRING127.readValue(buf));
            }
            return result;
        }

        @Nonnull
        public String getName() {
            return "T";
        }
    });

    protected ThingsValue(@Nonnull IValueFactory owner, @Nonnull String section, @Nonnull String keyname, @Nonnull Things defaultValue, @Nonnull String text) {
        super(owner, section, keyname, (Object)defaultValue, text);
    }

    @Nullable
    protected Things makeValue() {
        Property prop = this.owner.getConfig().get(this.section, this.keyname, (String[])((Things)this.defaultValue).getNameList().toArray((Object[])new String[0]));
        prop.setLanguageKey(this.keyname);
        prop.setValidValues(null);
        prop.setComment(this.getText() + " [default: " + prop.getDefault() + "]");
        prop.setRequiresMcRestart(this.isStartup);
        return new Things(prop.getStringList());
    }

    @Nonnull
    protected IByteBufAdapter<Things> getDataType() {
        return THINGS;
    }
}

