/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeExporter
extends NetworkNode
implements IComparable,
IType,
ICoverable {
    public static final String ID = "exporter";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_COVERS = "Covers";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private FluidInventory fluidFilters = new FluidInventory(9, new ListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 3, 4);
    private int compare = 3;
    private int type = 0;
    private CoverManager coverManager = new CoverManager(this);
    private int filterSlot;

    public NetworkNodeExporter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.exporterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed() == 0) {
            if (this.type == 0) {
                IItemHandler handler = WorldUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
                if (handler != null) {
                    ItemStack slot;
                    while (this.filterSlot + 1 < this.itemFilters.getSlots() && this.itemFilters.getStackInSlot(this.filterSlot).func_190926_b()) {
                        ++this.filterSlot;
                    }
                    if (this.filterSlot == this.itemFilters.getSlots() - 1 && this.itemFilters.getStackInSlot(this.filterSlot).func_190926_b() || this.filterSlot >= this.itemFilters.getSlots()) {
                        this.filterSlot = 0;
                    }
                    if (!(slot = this.itemFilters.getStackInSlot(this.filterSlot)).func_190926_b()) {
                        int stackSize = this.upgrades.getItemInteractCount();
                        ItemStack took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, Action.SIMULATE);
                        if (took == null) {
                            if (this.upgrades.hasUpgrade(3)) {
                                this.network.getCraftingManager().request((INetworkNode)this, slot, stackSize);
                            }
                        } else if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true).func_190926_b() && (took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, Action.PERFORM)) != null) {
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                        }
                    }
                    ++this.filterSlot;
                }
            } else if (this.type == 1) {
                IFluidHandler handler;
                FluidStack[] fluids = this.fluidFilters.getFluids();
                while (this.filterSlot + 1 < fluids.length && fluids[this.filterSlot] == null) {
                    ++this.filterSlot;
                }
                if (this.filterSlot == fluids.length - 1 && fluids[this.filterSlot] == null || this.filterSlot >= fluids.length) {
                    this.filterSlot = 0;
                }
                if ((handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null) {
                    FluidStack stack = fluids[this.filterSlot];
                    if (stack != null) {
                        int toExtract = 1000 * this.upgrades.getItemInteractCount();
                        FluidStack stackInStorage = this.network.getFluidStorageCache().getList().get(stack, this.compare);
                        if (stackInStorage != null) {
                            int filled;
                            FluidStack took = this.network.extractFluid(stack, toExtract = Math.min(toExtract, stackInStorage.amount), this.compare, Action.SIMULATE);
                            if (took != null && (filled = handler.fill(took, false)) > 0) {
                                took = this.network.extractFluid(stack, filled, this.compare, Action.PERFORM);
                                handler.fill(took, true);
                            }
                        } else if (this.upgrades.hasUpgrade(3)) {
                            this.network.getCraftingManager().request((INetworkNode)this, stack, toExtract);
                        }
                    }
                    ++this.filterSlot;
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_74782_a(NBT_FLUID_FILTERS, (NBTBase)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgrades, this.coverManager.getAsInventory()});
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileExporter.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

