/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.waila;

import com.gendeathrow.hatchery.block.feeder.FeederTileEntity;
import com.gendeathrow.hatchery.block.nest.EggNestTileEntity;
import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.gendeathrow.hatchery.modaddons.ChickensHelper;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@WailaPlugin
public class HatcheryTileProvider
implements IWailaDataProvider,
IWailaPlugin {
    private static final HatcheryTileProvider INSTANCE = new HatcheryTileProvider();

    public void register(IWailaRegistrar registrar) {
        HatcheryTileProvider.load(registrar);
    }

    public static void load(IWailaRegistrar registrar) {
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, EggNestTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, EggNestTileEntity.class);
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, NestPenTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, NestPenTileEntity.class);
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, FeederTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, FeederTileEntity.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof EggNestTileEntity) {
            EggNestTileEntity hte = (EggNestTileEntity)tileEntity;
            if (accessor.getNBTData().func_74767_n("hasEgg")) {
                float percentage = accessor.getNBTData().func_74760_g("hatchPercentage");
                currenttip.add(I18n.func_135052_a((String)"text.hatchery.hatching", (Object[])new Object[0]) + ": " + percentage + "%");
                currenttip.add(accessor.getNBTData().func_74779_i("eggName"));
            } else {
                currenttip.add(TextFormatting.RED + I18n.func_135052_a((String)"text.hatchery.nothatching", (Object[])new Object[0]));
            }
        } else if (tileEntity instanceof NestPenTileEntity) {
            int i;
            if (accessor.getNBTData().func_74767_n("hasChicken")) {
                currenttip.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"text.hatchery.chicken", (Object[])new Object[0]) + TextFormatting.RESET + ": " + TextFormatting.ITALIC + "" + TextFormatting.GREEN + accessor.getNBTData().func_74779_i("entityname"));
                if (accessor.getNBTData().func_74764_b("stats")) {
                    NBTTagList statList = accessor.getNBTData().func_150295_c("stats", 10);
                    for (i = 0; i < statList.func_74745_c(); ++i) {
                        NBTTagCompound statTag = statList.func_150305_b(i);
                        String unformatted = statTag.func_74779_i("text");
                        int value = statTag.func_74762_e("value");
                        currenttip.add(I18n.func_135052_a((String)unformatted, (Object[])new Object[]{value}));
                    }
                }
                long uptime = accessor.getNBTData().func_74763_f("nextDrop") / 20L;
                long minutes = TimeUnit.SECONDS.toMinutes(uptime);
                long seconds = TimeUnit.SECONDS.toSeconds(uptime -= TimeUnit.MINUTES.toSeconds(minutes));
                String output = minutes > 0L ? minutes + ":" + (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + " mins" : (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + " secs";
                currenttip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"text.hatchery.nxdrop", (Object[])new Object[0]) + ": " + output);
            } else {
                currenttip.add(TextFormatting.RED + I18n.func_135052_a((String)"text.hatchery.nochicken", (Object[])new Object[0]));
            }
            if (accessor.getNBTData().func_74764_b("inventory")) {
                NBTTagList inv = (NBTTagList)accessor.getNBTData().func_74781_a("inventory");
                currenttip.add("");
                currenttip.add(TextFormatting.GREEN + "" + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"text.hatchery.inventory", (Object[])new Object[0]) + TextFormatting.RESET);
                if (inv != null) {
                    for (i = 0; i < inv.func_74745_c(); ++i) {
                        NBTTagCompound item = inv.func_150305_b(i);
                        currenttip.add(TextFormatting.GOLD + "  Slot " + (item.func_74771_c("Slot") + 1) + TextFormatting.RESET + ": " + item.func_74779_i("id") + " x" + item.func_74762_e("cnt"));
                    }
                }
            } else {
                currenttip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"text.hatchery.sneakshow", (Object[])new Object[0]));
            }
        } else if (tileEntity instanceof FeederTileEntity && accessor.getNBTData().func_74764_b("qty")) {
            accessor.getNBTData().func_74779_i("qty");
            currenttip.add(I18n.func_135052_a((String)"text.hatchery.storedseed", (Object[])new Object[0]) + ": " + accessor.getNBTData().func_74779_i("qty"));
        }
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof EggNestTileEntity) {
            EggNestTileEntity hte = (EggNestTileEntity)te;
            if (!hte.getEgg().func_190926_b()) {
                tag.func_74776_a("hatchPercentage", hte.getPercentage());
                tag.func_74778_a("eggName", hte.getEgg().func_82833_r());
            }
            tag.func_74757_a("hasEgg", !hte.getEgg().func_190926_b());
        } else if (te instanceof NestPenTileEntity) {
            NBTTagList list;
            NestPenTileEntity hte = (NestPenTileEntity)te;
            tag.func_74757_a("hasChicken", hte.storedEntity() != null);
            if (hte.storedEntity() != null) {
                HashMap<String, Integer> stats;
                tag.func_74778_a("entityname", hte.storedEntity().func_145748_c_().func_150254_d());
                if (ChickensHelper.isLoaded() && (stats = ChickensHelper.getChickenStats((Entity)hte.storedEntity())) != null) {
                    NBTTagList statsTag = new NBTTagList();
                    NBTTagCompound growth = new NBTTagCompound();
                    growth.func_74778_a("text", "entity.ChickensChicken.growth");
                    growth.func_74768_a("value", stats.get("entity.ChickensChicken.growth").intValue());
                    NBTTagCompound gain = new NBTTagCompound();
                    gain.func_74778_a("text", "entity.ChickensChicken.gain");
                    gain.func_74768_a("value", stats.get("entity.ChickensChicken.gain").intValue());
                    NBTTagCompound str = new NBTTagCompound();
                    str.func_74778_a("text", "entity.ChickensChicken.strength");
                    str.func_74768_a("value", stats.get("entity.ChickensChicken.strength").intValue());
                    statsTag.func_74742_a((NBTBase)growth);
                    statsTag.func_74742_a((NBTBase)gain);
                    statsTag.func_74742_a((NBTBase)str);
                    if (!statsTag.func_82582_d()) {
                        tag.func_74782_a("stats", (NBTBase)statsTag);
                    }
                }
            }
            tag.func_74772_a("nextDrop", (long)hte.getTimeToNextDrop());
            if (player.func_70093_af() && (list = NestPenTileEntity.getInventoryContents(hte)) != null) {
                tag.func_74782_a("inventory", (NBTBase)list);
            }
        } else if (te instanceof FeederTileEntity) {
            FeederTileEntity hte = (FeederTileEntity)te;
            tag.func_74778_a("qty", hte.getSeedsInv() + "/" + hte.getMaxSeedInv());
        }
        return tag;
    }
}

