/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.nest;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.block.nest.EggNestBlock;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.modaddons.ChickensHelper;
import com.gendeathrow.hatchery.network.HatcheryPacket;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import com.gendeathrow.hatchery.util.ItemStackEntityNBTHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EggNestTileEntity
extends TileEntity
implements ITickable {
    boolean hasEgg;
    InventoryStroageModifiable inventory = new InventoryStroageModifiable("egg", 1){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return stack.func_77973_b() == ModItems.hatcheryEgg || stack.func_77973_b() == Items.field_151110_aK || stack.func_77973_b() instanceof ItemEgg;
        }
    };
    int hatchingTick = 0;
    private final int timeToHatch = 300;
    boolean bonusLight = false;
    boolean bonusPlayer = false;
    int ticks;
    boolean firstload = true;
    private boolean sentRequest = false;

    public ItemStack getEgg() {
        return this.inventory.getStackInSlot(0);
    }

    public void insertEgg(ItemStack eggIn) {
        if (!eggIn.func_190926_b() && this.inventory.getStackInSlot(0).func_190926_b()) {
            this.inventory.insertItem(0, eggIn.func_77946_l(), false);
        }
        this.func_70296_d();
    }

    public ItemStack removeEgg() {
        ItemStack stack = this.inventory.getAndRemoveSlot(0);
        this.func_70296_d();
        return stack;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == ModBlocks.nest && newSate.func_177230_c() == ModBlocks.nest) {
            return false;
        }
        return oldState != newSate;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.updateClient();
            return;
        }
        ++this.ticks;
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            boolean flag1;
            boolean flag = this.func_145831_w() != null;
            boolean bl = flag1 = !flag || this.func_145838_q() == ModBlocks.nest;
            if (flag1 && EggNestBlock.doesHaveEgg(this.field_145850_b.func_180495_p(this.func_174877_v()))) {
                int randint = 2;
                if (this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c)).size() > 0) {
                    randint += 5;
                }
                this.hatchingTick += this.field_145850_b.field_73012_v.nextInt(randint) + (this.checkForHeatLamp() ? 2 : 1);
                this.ticks = 0;
                if (this.hatchingTick > 300) {
                    block18: {
                        try {
                            if (this.getEgg().func_77973_b() == ModItems.hatcheryEgg) {
                                Entity entitychicken = null;
                                if (this.getEgg().func_77978_p() == null) {
                                    this.spawnMCChicken();
                                    Hatchery.logger.error("Error trying to spawn Hatchery Egg 'Null NBT' ");
                                    break block18;
                                }
                                NBTTagCompound entityTag = ItemStackEntityNBTHelper.getEntityTagFromStack(this.getEgg());
                                try {
                                    entitychicken = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)this.field_145850_b);
                                }
                                catch (Throwable e) {
                                    Hatchery.logger.error("Error trying to spawn Hatchery Egg from NBT ' " + e);
                                }
                                if (entitychicken != null) {
                                    entitychicken.func_70012_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0f, 0.0f);
                                    this.field_145850_b.func_72838_d(entitychicken);
                                    this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187666_Z, SoundCategory.AMBIENT, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                } else {
                                    this.spawnMCChicken();
                                }
                                break block18;
                            }
                            if (this.getEgg().func_77973_b() == Items.field_151110_aK) {
                                this.spawnMCChicken();
                            } else if (ChickensHelper.isLoaded()) {
                                ChickensHelper.spawnChickenType(this.func_145831_w(), this.func_174877_v(), ChickensHelper.getDyeChickenfromItemStack(this.getEgg()));
                                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187666_Z, SoundCategory.AMBIENT, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            }
                        }
                        catch (Throwable e) {
                            Hatchery.logger.error("Error trying to spawn Egg in the nest (" + this.func_174877_v().toString() + ") 'Null NBT' " + e);
                        }
                    }
                    this.removeEgg();
                    EggNestBlock.removeEgg(this.field_145850_b, this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v());
                }
            }
        } else if (this.hatchingTick > 300) {
            this.hatchingTick = 0;
            this.ticks = 0;
        }
    }

    public void updateClient() {
        if (!this.getEgg().func_190926_b()) {
            return;
        }
        boolean hasEgg = EggNestBlock.doesHaveEgg(this.func_145831_w().func_180495_p(this.func_174877_v()));
        if (!this.sentRequest && hasEgg) {
            Hatchery.network.sendToServer((IMessage)HatcheryPacket.requestItemstackTE(this.func_174877_v()));
            this.sentRequest = true;
        } else if (Minecraft.func_71386_F() % 80L == 0L && this.sentRequest && hasEgg) {
            this.sentRequest = false;
        }
    }

    public float getPercentage() {
        return this.hatchingTick * 100 / 300;
    }

    private boolean checkForHeatLamp() {
        RayTraceResult result = this.field_145850_b.func_72933_a(new Vec3d((Vec3i)this.field_174879_c), new Vec3d((Vec3i)this.field_174879_c.func_177981_b(3)));
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = this.field_145850_b.func_180495_p(result.func_178782_a());
            if (state.func_177230_c() == Blocks.field_150379_bu) {
                // empty if block
            }
            return this.field_145850_b.func_175640_z(result.func_178782_a());
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.hatchingTick = compound.func_74762_e("hatchTime");
        this.inventory.readFromNBT(compound);
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("hatchTime", this.hatchingTick);
        compound = this.inventory.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    private void spawnMCChicken() {
        EntityChicken chicken = new EntityChicken(this.field_145850_b);
        chicken.func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p());
        chicken.func_70873_a(-24000);
        this.field_145850_b.func_72838_d((Entity)chicken);
        this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187666_Z, SoundCategory.AMBIENT, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound sendnbt = new NBTTagCompound();
        sendnbt = this.func_189515_b(sendnbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), sendnbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_70296_d();
    }

    public NBTTagCompound getWailaUpdatePacket() {
        NBTTagCompound sendnbt = new NBTTagCompound();
        sendnbt.func_74768_a("hatchTime", this.hatchingTick);
        return sendnbt;
    }

    public int getWailaHatchTime(NBTTagCompound nbt) {
        return nbt.func_74762_e("hatchTime");
    }
}

