/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.types;

import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.EntityInfo;
import net.minecraft.item.crafting.Ingredient;

public class FluidBlockTransformer {
    private String fluidName;
    private Ingredient input;
    private BlockInfo output;
    private EntityInfo toSpawn;
    private int spawnCount;
    private int spawnRange;

    public FluidBlockTransformer(String fluidName, Ingredient input, BlockInfo output) {
        this(fluidName, input, output, (String)null, 0, 0);
    }

    public FluidBlockTransformer(String fluidName, Ingredient input, BlockInfo output, String entityName) {
        this(fluidName, input, output, entityName, 4, 4);
    }

    public FluidBlockTransformer(String fluidName, Ingredient input, BlockInfo output, String entityName, int spawnCount, int spawnRange) {
        this.fluidName = fluidName;
        this.input = input;
        this.output = output;
        this.toSpawn = entityName == null ? EntityInfo.EMPTY : new EntityInfo(entityName);
        this.spawnCount = spawnCount;
        this.spawnRange = spawnRange;
    }

    public FluidBlockTransformer(String fluidName, Ingredient input, BlockInfo output, EntityInfo toSpawn, int spawnCount, int spawnRange) {
        this.fluidName = fluidName;
        this.input = input;
        this.output = output;
        this.toSpawn = toSpawn;
        this.spawnCount = spawnCount;
        this.spawnRange = spawnRange;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FluidBlockTransformer)) {
            return false;
        }
        FluidBlockTransformer other = (FluidBlockTransformer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fluidName = this.getFluidName();
        String other$fluidName = other.getFluidName();
        if (this$fluidName == null ? other$fluidName != null : !this$fluidName.equals(other$fluidName)) {
            return false;
        }
        Ingredient this$input = this.getInput();
        Ingredient other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        BlockInfo this$output = this.getOutput();
        BlockInfo other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        EntityInfo this$toSpawn = this.getToSpawn();
        EntityInfo other$toSpawn = other.getToSpawn();
        if (this$toSpawn == null ? other$toSpawn != null : !this$toSpawn.equals(other$toSpawn)) {
            return false;
        }
        if (this.getSpawnCount() != other.getSpawnCount()) {
            return false;
        }
        return this.getSpawnRange() == other.getSpawnRange();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FluidBlockTransformer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fluidName = this.getFluidName();
        result = result * 59 + ($fluidName == null ? 43 : $fluidName.hashCode());
        Ingredient $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        BlockInfo $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        EntityInfo $toSpawn = this.getToSpawn();
        result = result * 59 + ($toSpawn == null ? 43 : $toSpawn.hashCode());
        result = result * 59 + this.getSpawnCount();
        result = result * 59 + this.getSpawnRange();
        return result;
    }

    public String getFluidName() {
        return this.fluidName;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public BlockInfo getOutput() {
        return this.output;
    }

    public EntityInfo getToSpawn() {
        return this.toSpawn;
    }

    public int getSpawnCount() {
        return this.spawnCount;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }
}

