/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SieveRegistry
extends BaseRegistryMap<Ingredient, NonNullList<Siftable>> {
    public SieveRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Ingredient.class, (Object)new CustomIngredientJson()).registerTypeAdapter(OreIngredientStoring.class, (Object)new CustomIngredientJson()).registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, List<Siftable>>>(){}.getType(), ExNihiloRegistryManager.SIEVE_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(ItemStack itemStack, StackInfo drop, float chance, int meshLevel) {
        if (itemStack.func_190926_b()) {
            return;
        }
        if (drop instanceof ItemInfo) {
            this.register(CraftingHelper.getIngredient((Object)itemStack), new Siftable((ItemInfo)drop, chance, meshLevel));
        } else {
            this.register(CraftingHelper.getIngredient((Object)itemStack), new Siftable(new ItemInfo(drop.getItemStack()), chance, meshLevel));
        }
    }

    public void register(Item item, int meta, StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack(item, 1, meta), drop, chance, meshLevel);
    }

    public void register(StackInfo item, StackInfo drop, float chance, int meshLevel) {
        this.register(item.getItemStack(), drop, chance, meshLevel);
    }

    public void register(Block block, int meta, StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack(block, 1, meta), drop, chance, meshLevel);
    }

    public void register(IBlockState state, StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), drop, chance, meshLevel);
    }

    public void register(ResourceLocation location, int meta, StackInfo drop, float chance, int meshLevel) {
        this.register(new ItemStack((Item)ForgeRegistries.ITEMS.getValue(location), 1, meta), drop, chance, meshLevel);
    }

    public void register(String name, StackInfo drop, float chance, int meshLevel) {
        if (drop instanceof ItemInfo) {
            this.register((Ingredient)new OreIngredientStoring(name), new Siftable((ItemInfo)drop, chance, meshLevel));
        } else {
            this.register((Ingredient)new OreIngredientStoring(name), new Siftable(new ItemInfo(drop.getItemStack()), chance, meshLevel));
        }
    }

    @Override
    public void register(Ingredient ingredient, Siftable drop) {
        if (ingredient == null) {
            return;
        }
        Ingredient search = ((Map)this.registry).keySet().stream().filter(entry -> IngredientUtil.ingredientEquals(entry, ingredient)).findAny().orElse(null);
        if (search != null) {
            ((NonNullList)((Map)this.registry).get(search)).add((Object)drop);
        } else {
            NonNullList drops = NonNullList.func_191196_a();
            drops.add((Object)drop);
            super.register(ingredient, drops);
        }
    }

    public List<Siftable> getDrops(StackInfo stack) {
        return this.getDrops(stack.getItemStack());
    }

    public List<Siftable> getDrops(ItemStack stack) {
        ArrayList<Siftable> drops = new ArrayList<Siftable>();
        if (!stack.func_190926_b()) {
            ((Map)this.registry).entrySet().stream().filter(entry -> ((Ingredient)entry.getKey()).test((Object)stack)).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        }
        return drops;
    }

    public List<Siftable> getDrops(Ingredient ingredient) {
        ArrayList<Siftable> drops = new ArrayList<Siftable>();
        ((Map)this.registry).entrySet().stream().filter(entry -> entry.getKey() == ingredient).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        return drops;
    }

    public List<ItemStack> getRewardDrops(Random random, IBlockState block, int meshLevel, int fortuneLevel) {
        if (block == null) {
            return null;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.getDrops(new BlockInfo(block)).forEach(siftable -> {
            if (meshLevel == siftable.getMeshLevel()) {
                int triesWithFortune = Math.max(random.nextInt(fortuneLevel + 2), 1);
                for (int i = 0; i < triesWithFortune; ++i) {
                    if (!(random.nextDouble() < (double)siftable.getChance())) continue;
                    drops.add(siftable.getDrop().getItemStack());
                }
            }
        });
        return drops;
    }

    public boolean canBeSifted(ItemStack stack) {
        return !stack.func_190926_b() && ((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)stack));
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<Ingredient, ArrayList<Siftable>>>(){}.getType());
        for (Map.Entry input : gsonInput.entrySet()) {
            Ingredient key = (Ingredient)input.getKey();
            if (key == null || key == Ingredient.field_193370_a) continue;
            for (Siftable siftable : (ArrayList)input.getValue()) {
                if (!siftable.getDrop().isValid()) continue;
                this.register(key, siftable);
            }
        }
    }

    @Override
    public List<SieveRecipe> getRecipeList() {
        ArrayList<SieveRecipe> sieveRecipes = new ArrayList<SieveRecipe>();
        ((Map)this.getRegistry()).keySet().forEach(ingredient -> Stream.of(BlockSieve.MeshType.values()).forEach(meshType -> {
            SieveRecipe recipe;
            if (meshType.getID() != 0 && ingredient != null && (recipe = new SieveRecipe((Ingredient)ingredient, (BlockSieve.MeshType)((Object)((Object)meshType)))).isValid() && !sieveRecipes.contains(recipe)) {
                sieveRecipes.add(recipe);
            }
        }));
        return sieveRecipes;
    }
}

