/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.items.ore.EnumOreSubtype;
import exnihilocreatio.items.ore.ItemOre;
import exnihilocreatio.items.ore.Ore;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomColorJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.json.CustomOreJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryList;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import wanion.unidict.UniDict;

public class OreRegistry
extends BaseRegistryList<Ore> {
    private List<ItemOre> itemOreRegistry = new ArrayList<ItemOre>();
    private Set<ItemOre> sieveBlackList = new HashSet<ItemOre>();

    public OreRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).registerTypeAdapter(Ore.class, (Object)new CustomOreJson()).registerTypeAdapter(Color.class, (Object)new CustomColorJson()).create(), ExNihiloRegistryManager.ORE_DEFAULT_REGISTRY_PROVIDERS);
    }

    public Ore register(String name, Color color, ItemInfo info) {
        return this.register(name, color, info, null, null);
    }

    public Ore register(String name, Color color, ItemInfo info, HashMap<String, String> translations, String oredictName) {
        Ore ore = new Ore(name, color, info, translations, oredictName);
        this.register(ore);
        return ore;
    }

    @Override
    public void register(Ore value) {
        ((List)this.registry).add(value);
        this.itemOreRegistry.add(new ItemOre(value));
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<Ore>>(){}.getType());
        for (Ore ore : gsonInput) {
            this.register(ore);
        }
    }

    public void doRecipes() {
        for (ItemOre ore : this.itemOreRegistry) {
            ItemStack smeltingResult;
            ResourceLocation group = new ResourceLocation("exnihilocreatio", "exores");
            ResourceLocation baseName = new ResourceLocation("exnihilocreatio", "ore_compression_");
            ResourceLocation recipeLocation = new ResourceLocation(baseName.func_110624_b(), baseName.func_110623_a() + ore.getOre().getName());
            GameRegistry.addShapedRecipe((ResourceLocation)recipeLocation, (ResourceLocation)group, (ItemStack)new ItemStack((Item)ore, 1, EnumOreSubtype.CHUNK.getMeta()), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Item)ore, 1, EnumOreSubtype.PIECE.getMeta())});
            if (ModConfig.compatibility.preventUnidict && Loader.isModLoaded((String)"unidict")) {
                UniDict.getConfig().recipesToIgnore.add(recipeLocation);
            }
            if (ore.isRegisterIngot()) {
                smeltingResult = new ItemStack((Item)ore, 1, 3);
                OreDictionary.registerOre((String)("ingot" + StringUtils.capitalize((String)ore.getOre().getName())), (ItemStack)smeltingResult);
                if (ore.getOre().getName().contains("aluminium")) {
                    OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)smeltingResult);
                }
            } else {
                smeltingResult = ore.getOre().getResult().getItemStack();
            }
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ore, 1, EnumOreSubtype.CHUNK.getMeta()), smeltingResult, 0.7f);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ore, 1, EnumOreSubtype.DUST.getMeta()), smeltingResult, 0.7f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels() {
        ItemMeshDefinition ORES = stack -> {
            switch (stack.func_77952_i()) {
                case 0: {
                    return new ModelResourceLocation("exnihilocreatio:item_ore", "type=piece");
                }
                case 1: {
                    return new ModelResourceLocation("exnihilocreatio:item_ore", "type=chunk");
                }
                case 2: {
                    return new ModelResourceLocation("exnihilocreatio:item_ore", "type=dust");
                }
                case 3: {
                    return new ModelResourceLocation("exnihilocreatio:item_ore", "type=ingot");
                }
            }
            return new ModelResourceLocation(stack.func_77973_b().getRegistryName() == null ? new ResourceLocation("exnihilocreatio:item_ore") : stack.func_77973_b().getRegistryName(), "inventory");
        };
        for (ItemOre ore : this.itemOreRegistry) {
            ModelLoader.setCustomMeshDefinition((Item)ore, (ItemMeshDefinition)ORES);
            ModelBakery.registerItemVariants((Item)ore, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("exnihilocreatio:item_ore", "type=piece"), new ModelResourceLocation("exnihilocreatio:item_ore", "type=chunk"), new ModelResourceLocation("exnihilocreatio:item_ore", "type=dust"), new ModelResourceLocation("exnihilocreatio:item_ore", "type=ingot")});
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a((Item)ore, ORES);
        }
    }

    public void registerToGameRegistry(IForgeRegistry<Item> itemRegistry) {
        String bChunk = ModConfig.ore.chunkBaseOreDictName;
        String bDust = ModConfig.ore.dustBaseOreDictName;
        String bPiece = ModConfig.ore.pieceBaseOreDictName;
        String bIngot = ModConfig.ore.ingotBaseOreDictName;
        for (ItemOre itemOre : this.itemOreRegistry) {
            itemRegistry.register((IForgeRegistryEntry)itemOre);
            String oreName = itemOre.getOre().getOredictName() != null ? itemOre.getOre().getOredictName() : StringUtils.capitalize((String)itemOre.getOre().getName());
            OreDictionary.registerOre((String)(bChunk + oreName), (ItemStack)new ItemStack((Item)itemOre, 1, EnumOreSubtype.CHUNK.getMeta()));
            OreDictionary.registerOre((String)(bDust + oreName), (ItemStack)new ItemStack((Item)itemOre, 1, EnumOreSubtype.DUST.getMeta()));
            OreDictionary.registerOre((String)(bPiece + oreName), (ItemStack)new ItemStack((Item)itemOre, 1, EnumOreSubtype.PIECE.getMeta()));
            if (!itemOre.isRegisterIngot()) continue;
            OreDictionary.registerOre((String)(bIngot + oreName), (ItemStack)new ItemStack((Item)itemOre, 1, EnumOreSubtype.INGOT.getMeta()));
        }
    }

    public ItemOre getOreItem(String name) {
        for (ItemOre itemOre : this.itemOreRegistry) {
            if (!itemOre.getOre().getName().equals(name)) continue;
            return itemOre;
        }
        return null;
    }

    public boolean isRegistered(String name) {
        for (Ore ore : (List)this.registry) {
            if (!ore.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<?> getRecipeList() {
        return Lists.newLinkedList();
    }

    public List<ItemOre> getItemOreRegistry() {
        return this.itemOreRegistry;
    }

    public Set<ItemOre> getSieveBlackList() {
        return this.sieveBlackList;
    }
}

