/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryList;
import exnihilocreatio.registries.types.Milkable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraftforge.fluids.Fluid;

public class MilkEntityRegistry
extends BaseRegistryList<Milkable> {
    public MilkEntityRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create(), ExNihiloRegistryManager.MILK_ENTITY_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(Entity entityOnTop, Fluid result, int amount, int coolDown) {
        ((List)this.registry).add(new Milkable(entityOnTop.func_70005_c_(), result.getName(), amount, coolDown));
    }

    public void register(String entityOnTop, String result, int amount, int coolDown) {
        ((List)this.registry).add(new Milkable(entityOnTop, result, amount, coolDown));
    }

    public boolean isValidRecipe(Entity entityOnTop) {
        return entityOnTop != null && this.isValidRecipe(entityOnTop.func_70005_c_());
    }

    public boolean isValidRecipe(String entityOnTop) {
        if (entityOnTop == null) {
            return false;
        }
        for (Milkable milk : (List)this.registry) {
            if (!milk.getEntityOnTop().equals(entityOnTop)) continue;
            return true;
        }
        return false;
    }

    public Milkable getMilkable(Entity entityOnTop) {
        if (entityOnTop == null) {
            return null;
        }
        for (Milkable milk : (List)this.registry) {
            if (!milk.getEntityOnTop().equals(entityOnTop.func_70005_c_())) continue;
            return milk;
        }
        return null;
    }

    public String getResult(Entity entityOnTop) {
        for (Milkable milk : (List)this.registry) {
            if (!milk.getEntityOnTop().equals(entityOnTop.func_70005_c_())) continue;
            return milk.getResult();
        }
        return null;
    }

    public int getAmount(Entity entityOnTop) {
        for (Milkable milk : (List)this.registry) {
            if (!milk.getEntityOnTop().equals(entityOnTop.func_70005_c_())) continue;
            return milk.getAmount();
        }
        return 0;
    }

    public int getCoolDown(Entity entityOnTop) {
        for (Milkable milk : (List)this.registry) {
            if (!milk.getEntityOnTop().equals(entityOnTop.func_70005_c_())) continue;
            return milk.getCoolDown();
        }
        return 0;
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<Milkable>>(){}.getType());
        ((List)this.registry).addAll(gsonInput);
    }

    @Override
    public List<?> getRecipeList() {
        return Lists.newLinkedList();
    }
}

