/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.compatibility.jei.crucible.HeatSourcesRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.util.BlockInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class HeatRegistry
extends BaseRegistryMap<BlockInfo, Integer> {
    public HeatRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create(), new TypeToken<Map<BlockInfo, Integer>>(){}.getType(), ExNihiloRegistryManager.HEAT_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(BlockInfo info, int heatAmount) {
        ((Map)this.registry).put(info, heatAmount);
    }

    @Override
    public void register(ItemStack stack, int heatAmount) {
        this.register(new BlockInfo(stack), heatAmount);
    }

    public int getHeatAmount(ItemStack stack) {
        return (Integer)((Map)this.registry).get(new BlockInfo(stack));
    }

    public int getHeatAmount(BlockInfo info) {
        return ((Map)this.registry).getOrDefault(info, 0);
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, Integer>>(){}.getType());
        for (Map.Entry entry : gsonInput.entrySet()) {
            ((Map)this.registry).put(new BlockInfo((String)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public List<HeatSourcesRecipe> getRecipeList() {
        LinkedList heatSources = Lists.newLinkedList();
        ((Map)this.getRegistry()).forEach((key, value) -> heatSources.add(new HeatSourcesRecipe((BlockInfo)key, (int)value)));
        return heatSources;
    }
}

