/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomItemStackJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.CrookReward;
import exnihilocreatio.util.BlockInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;

public class CrookRegistry
extends BaseRegistryMap<Ingredient, NonNullList<CrookReward>> {
    public CrookRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson()).registerTypeAdapter(Ingredient.class, (Object)new CustomIngredientJson()).registerTypeAdapter(OreIngredientStoring.class, (Object)new CustomIngredientJson()).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, List<CrookReward>>>(){}.getType(), ExNihiloRegistryManager.CROOK_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(Block block, int meta, ItemStack reward, float chance, float fortuneChance) {
        this.register(new BlockInfo(block, meta), reward, chance, fortuneChance);
    }

    public void register(IBlockState state, ItemStack reward, float chance, float fortuneChance) {
        this.register(new BlockInfo(state), reward, chance, fortuneChance);
    }

    public void register(BlockInfo info, ItemStack reward, float chance, float fortuneChance) {
        Ingredient ingredient = ((Map)this.registry).keySet().stream().filter(entry -> entry.test((Object)info.getItemStack())).findFirst().orElse(null);
        if (ingredient != null) {
            ((NonNullList)((Map)this.registry).get(ingredient)).add((Object)new CrookReward(reward, chance, fortuneChance));
        } else {
            NonNullList list = NonNullList.func_191196_a();
            list.add((Object)new CrookReward(reward, chance, fortuneChance));
            ((Map)this.registry).put(CraftingHelper.getIngredient((Object)info), list);
        }
    }

    public void register(String name, ItemStack reward, float chance, float fortuneChance) {
        OreIngredientStoring ingredient = new OreIngredientStoring(name);
        CrookReward crookReward = new CrookReward(reward, chance, fortuneChance);
        Ingredient search = ((Map)this.registry).keySet().stream().filter(arg_0 -> CrookRegistry.lambda$register$1((Ingredient)ingredient, arg_0)).findAny().orElse(null);
        if (search != null) {
            ((NonNullList)((Map)this.registry).get(search)).add((Object)crookReward);
        } else {
            NonNullList drops = NonNullList.func_191196_a();
            drops.add((Object)crookReward);
            ((Map)this.registry).put(ingredient, drops);
        }
    }

    public boolean isRegistered(Block block) {
        ItemStack stack = new ItemStack(block);
        return ((Map)this.registry).keySet().stream().anyMatch(ingredient -> ingredient.test((Object)stack));
    }

    public List<CrookReward> getRewards(IBlockState state) {
        BlockInfo info = new BlockInfo(state);
        ArrayList<CrookReward> list = new ArrayList<CrookReward>();
        ((Map)this.registry).entrySet().stream().filter(ingredient -> ((Ingredient)ingredient.getKey()).test((Object)info.getItemStack())).forEach(ingredient -> list.addAll((Collection)ingredient.getValue()));
        return list;
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, NonNullList<CrookReward>>>(){}.getType());
        gsonInput.forEach((key, value) -> {
            Ingredient ingredient = IngredientUtil.parseFromString(key);
            if (ingredient != null) {
                NonNullList list = ((Map)this.registry).getOrDefault(ingredient, NonNullList.func_191196_a());
                list.addAll((Collection)value);
                ((Map)this.registry).put(ingredient, list);
            }
        });
    }

    @Override
    public List<?> getRecipeList() {
        return Lists.newLinkedList();
    }

    private static /* synthetic */ boolean lambda$register$1(Ingredient ingredient, Ingredient entry) {
        return IngredientUtil.ingredientEquals(entry, ingredient);
    }
}

