/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomColorJson;
import exnihilocreatio.json.CustomCompostableJson;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CompostRegistry
extends BaseRegistryMap<Ingredient, Compostable> {
    protected final Map<Ingredient, Compostable> oreRegistry = new HashMap<Ingredient, Compostable>();

    public CompostRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Ingredient.class, (Object)new CustomIngredientJson()).registerTypeAdapter(OreIngredientStoring.class, (Object)new CustomIngredientJson()).registerTypeAdapter(Compostable.class, (Object)new CustomCompostableJson()).registerTypeAdapter(Color.class, (Object)new CustomColorJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, Compostable>>(){}.getType(), ExNihiloRegistryManager.COMPOST_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(ItemStack itemStack, float value, BlockInfo state, Color color) {
        if (itemStack.func_190926_b()) {
            return;
        }
        Ingredient ingredient = CraftingHelper.getIngredient((Object)itemStack);
        if (((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)itemStack))) {
            LogUtil.error("Compost Entry for " + itemStack.func_77973_b().getRegistryName() + " with meta " + itemStack.func_77960_j() + " already exists, skipping.");
            return;
        }
        Compostable compostable = new Compostable(value, color, state);
        this.register(ingredient, compostable);
    }

    public void register(Item item, int meta, float value, BlockInfo state, Color color) {
        this.register(new ItemStack(item, 1, meta), value, state, color);
    }

    public void register(Block block, int meta, float value, BlockInfo state, Color color) {
        this.register(new ItemStack(block, 1, meta), value, state, color);
    }

    public void register(StackInfo item, float value, BlockInfo state, Color color) {
        this.register(item.getItemStack(), value, state, color);
    }

    public void register(ResourceLocation location, int meta, float value, BlockInfo state, Color color) {
        this.register((Item)ForgeRegistries.ITEMS.getValue(location), meta, value, state, color);
    }

    public void register(String name, float value, BlockInfo state, Color color) {
        OreIngredientStoring ingredient = new OreIngredientStoring(name);
        Compostable compostable = new Compostable(value, color, state);
        if (this.oreRegistry.keySet().stream().anyMatch(arg_0 -> CompostRegistry.lambda$register$1((Ingredient)ingredient, arg_0))) {
            LogUtil.error("Compost Ore Entry for " + name + " already exists, skipping.");
        } else {
            this.register(ingredient, compostable);
        }
    }

    public void register(String name, float value, BlockInfo state) {
        this.register(name, value, state, Color.INVALID_COLOR);
    }

    public Compostable getItem(Item item, int meta) {
        return this.getItem(new ItemStack(item, meta));
    }

    public Compostable getItem(ItemStack stack) {
        Ingredient ingredient = ((Map)this.registry).keySet().stream().filter(entry -> entry.test((Object)stack)).findFirst().orElse(null);
        if (ingredient != null) {
            return (Compostable)((Map)this.registry).get(ingredient);
        }
        ingredient = this.oreRegistry.keySet().stream().filter(entry -> entry.test((Object)stack)).findFirst().orElse(null);
        if (ingredient != null) {
            return this.oreRegistry.get(ingredient);
        }
        return Compostable.EMPTY;
    }

    public Compostable getItem(StackInfo info) {
        return this.getItem(info.getItemStack());
    }

    public boolean containsItem(Item item, int meta) {
        return this.containsItem(new ItemStack(item, meta));
    }

    public boolean containsItem(ItemStack stack) {
        return ((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)stack)) || this.oreRegistry.keySet().stream().anyMatch(entry -> entry.test((Object)stack));
    }

    public boolean containsItem(StackInfo info) {
        return this.containsItem(info.getItemStack());
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, Compostable>>(){}.getType());
        for (Map.Entry entry : gsonInput.entrySet()) {
            Ingredient ingr = IngredientUtil.parseFromString((String)entry.getKey());
            if (((Map)this.registry).keySet().stream().anyMatch(ingredient -> IngredientUtil.ingredientEquals(ingredient, ingr))) {
                LogUtil.error("Compost JSON Entry for " + (String)entry.getKey() + " already exists, skipping.");
                continue;
            }
            this.register(ingr, entry.getValue());
        }
    }

    @Override
    public Map<Ingredient, Compostable> getRegistry() {
        HashMap map = (HashMap)((HashMap)this.registry).clone();
        map.putAll(this.oreRegistry);
        return map;
    }

    @Override
    public List<CompostRecipe> getRecipeList() {
        ArrayList<CompostRecipe> compostRecipePages = new ArrayList<CompostRecipe>();
        this.getRegistry().forEach((key, value) -> {
            BlockInfo compostBlock = value.getCompostBlock();
            LinkedList compostables = Lists.newLinkedList();
            int compostCount = (int)Math.ceil(1.0f / value.getValue());
            ItemStack[] stacks = key.func_193365_a();
            if (stacks.length <= 0) {
                return;
            }
            for (ItemStack stack : stacks) {
                if (!compostables.stream().noneMatch(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0))) continue;
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(compostCount);
                compostables.add(copy);
            }
            CompostRecipe recipe = compostRecipePages.stream().filter(compostRecipe -> compostRecipe.outputMatch(compostBlock.getItemStack()) && compostRecipe.isNonFull()).findFirst().orElse(null);
            if (recipe == null) {
                recipe = new CompostRecipe(compostBlock, new ArrayList<List<ItemStack>>());
                compostRecipePages.add(recipe);
            }
            if (recipe.isNonFull()) {
                recipe.getInputs().add(compostables);
            } else {
                recipe = new CompostRecipe(compostBlock, Lists.newLinkedList());
                recipe.getInputs().add(compostables);
                compostRecipePages.add(recipe);
            }
        });
        return compostRecipePages;
    }

    private static /* synthetic */ boolean lambda$register$1(Ingredient ingredient, Ingredient entry) {
        return IngredientUtil.ingredientEquals(entry, ingredient);
    }
}

