/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CustomIngredientJson
implements JsonDeserializer<Ingredient>,
JsonSerializer<Ingredient> {
    public Ingredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() && ((JsonPrimitive)json).isString()) {
            String s = json.getAsString();
            return IngredientUtil.parseFromString(s);
        }
        LogUtil.error("Error parsing JSON: No Primitive String: " + json.toString());
        return Ingredient.field_193370_a;
    }

    public JsonElement serialize(Ingredient src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof OreIngredientStoring) {
            OreIngredientStoring ore = (OreIngredientStoring)src;
            return new JsonPrimitive("ore:" + ore.getOreName());
        }
        ItemStack[] stacks = src.func_193365_a();
        if (stacks.length > 0) {
            return new JsonPrimitive(stacks[0].func_77973_b().getRegistryName().toString() + ":" + stacks[0].func_77960_j());
        }
        return new JsonPrimitive("minecraft:air:0");
    }
}

