/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import java.lang.reflect.Type;

public class CustomCompostableJson
implements JsonDeserializer<Compostable>,
JsonSerializer<Compostable> {
    public JsonElement serialize(Compostable src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("value", (Number)Float.valueOf(src.getValue()));
        obj.add("compostBlock", context.serialize((Object)src.getCompostBlock(), BlockInfo.class));
        if (!src.getColor().equals(Color.INVALID_COLOR)) {
            obj.add("color", context.serialize((Object)src.getColor(), Color.class));
        }
        return obj;
    }

    public Compostable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = new JsonHelper(json);
        JsonObject obj = json.getAsJsonObject();
        Float value = Float.valueOf((float)helper.getDouble("value"));
        Color color = Color.INVALID_COLOR;
        if (obj.has("color")) {
            color = (Color)context.deserialize(json.getAsJsonObject().get("color"), Color.class);
        }
        BlockInfo result = (BlockInfo)context.deserialize(json.getAsJsonObject().get("compostBlock"), BlockInfo.class);
        return new Compostable(value.floatValue(), color, result);
    }
}

