/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;

public class CustomColorJson
implements JsonDeserializer<Color>,
JsonSerializer<Color> {
    public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isString()) {
                return new Color(prim.getAsString());
            }
            if (prim.isNumber()) {
                return new Color(prim.getAsInt());
            }
        } else {
            JsonHelper helper = new JsonHelper(json);
            return new Color((float)helper.getDouble("r"), (float)helper.getDouble("g"), (float)helper.getDouble("b"), (float)helper.getDouble("a"));
        }
        LogUtil.warn("Invalid Color primitive for " + json.toString());
        return Color.INVALID_COLOR;
    }

    public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.getAsHexNoAlpha());
    }
}

