/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="exnihilocreatio", name="exnihilocreatio/ExNihiloCreatio", category="exnihilocreatio")
public class ModConfig {
    @Config.Comment(value={"These configs can be changed ClientSided without making problems with connecting to a server"})
    public static final Client client = new Client();
    public static final Mechanics mechanics = new Mechanics();
    public static final Composting composting = new Composting();
    public static final InfestedLeaves infested_leaves = new InfestedLeaves();
    public static final Crooking crooking = new Crooking();
    public static final Misc misc = new Misc();
    public static final Sieve sieve = new Sieve();
    public static final Compatibility compatibility = new Compatibility();
    public static final Crucible crucible = new Crucible();
    public static final World world = new World();
    public static final Ore ore = new Ore();

    @Mod.EventBusSubscriber
    static class ConfigurationHolder {
        ConfigurationHolder() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("exnihilocreatio")) {
                ConfigManager.load((String)"exnihilocreatio", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Ore {
        public String chunkBaseOreDictName = "ore";
        public String pieceBaseOreDictName = "piece";
        public String dustBaseOreDictName = "dust";
        public String ingotBaseOreDictName = "ingot";
    }

    public static class World {
        public boolean isSkyWorld = true;
        public int normalDropPercent = 100;
    }

    public static class Crucible {
        public int woodenCrucibleSpeed = 4;
    }

    public static class Compatibility {
        @Config.RequiresMcRestart
        public TinkersConstructCompat tinkers_construct_compat = new TinkersConstructCompat();
        @Config.Comment(value={"Prevents unidict from merging the ore chunks into normal ore."})
        public boolean preventUnidict = true;
        public boolean addYelloriteOreDict = true;
        public boolean dankNullIntegration = true;
        public boolean generalItemHandlerCompat = true;

        public static class TinkersConstructCompat {
            public boolean doTinkersConstructCompat = true;
            public boolean addModifer = true;
            public boolean addMeltingOfChunks = true;
            public double ingotsPerChunkWhenMelting = 2.0;
            public boolean addMeltingOfDust = true;
            public double ingotsPerDustWhenMelting = 1.0;
        }
    }

    public static class Sieve {
        public int sieveSimilarRadius = 2;
        public int autoSieveRadius = 2;
        public boolean setFireToMacroUsers = false;
    }

    public static class Misc {
        public boolean enableBarrelTransformLighting = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable this to to load the JSON files.", "Keeping this on false will only load recipes registered in code", "This is recommended to enable for Packmakers", "For players just playing with this without wanting to configure something this is recommended to keep disabled"})
        public boolean enableJSONLoading = false;
        public boolean oredictVanillaItems = true;
    }

    public static class Crooking {
        public double stringChance = 1.0;
        public double stringFortuneChance = 1.0;
        public int numberOfTimesToTestVanillaDrops = 3;
    }

    public static class InfestedLeaves {
        public int ticksToTransform = 600;
        @Config.Comment(value={"How many ticks to wait before getting ticked again, already fully infested leaves spread much slower due to waiting for world ticks."})
        public int leavesUpdateFrequency = 5;
        @Config.Comment(value={"Minimum percentage to spread"})
        public int leavesSpreadPercent = 15;
        @Config.Comment(value={"Chance to spread if it got ticked"})
        public float leavesSpreadChanceFloat = 0.5f;
    }

    public static class Composting {
        public int ticksToFormDirt = 600;
    }

    public static class Mechanics {
        public boolean enableBarrels = true;
        public boolean enableCrucible = true;
        public boolean shouldBarrelsFillWithRain = true;
        public boolean fakePlayersCanSieve = false;
    }

    public static class Client {
        public boolean clientFancyAutoSieveAnimations = true;
        @Config.Comment(value={"This enables the thin Sieve model which is similar to the one in the 1.7 ex nihilo"})
        public boolean thinCrucibleModel = false;
    }
}

