/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.hammer;

import com.google.common.collect.Lists;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.HammerReward;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class HammerRecipe
implements IRecipeWrapper {
    private List<ItemStack> inputs;
    private List<ItemStack> outputs;

    public HammerRecipe(Ingredient ingredient) {
        NonNullList<HammerReward> rewards = ExNihiloRegistryManager.HAMMER_REGISTRY.getRewards(ingredient);
        if (rewards.isEmpty()) {
            return;
        }
        List allOutputs = rewards.stream().map(HammerReward::getStack).collect(Collectors.toList());
        this.inputs = Arrays.asList(ingredient.func_193365_a());
        this.outputs = Lists.newArrayList();
        for (ItemStack stack : allOutputs) {
            boolean alreadyExists = false;
            for (ItemStack outputStack : this.outputs) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)outputStack)) continue;
                outputStack.func_190917_f(stack.func_190916_E());
                alreadyExists = true;
                break;
            }
            if (alreadyExists) continue;
            this.outputs.add(stack);
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public boolean isValid() {
        return !this.inputs.isEmpty() && !this.outputs.isEmpty();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

