/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.barrel.fluidtransform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import exnihilocreatio.registries.types.FluidTransformer;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.Util;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidTransformRecipe
implements IRecipeWrapper {
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;
    private final ItemStack inputBucket;
    private final ItemStack outputBucket;
    private final List<ItemStack> inputStacks;

    public FluidTransformRecipe(FluidTransformer recipe) {
        this.inputFluid = new FluidStack(FluidRegistry.getFluid((String)recipe.getInputFluid()), 1000);
        this.outputFluid = new FluidStack(FluidRegistry.getFluid((String)recipe.getOutputFluid()), 1000);
        this.inputBucket = Util.getBucketStack(this.inputFluid.getFluid());
        this.outputBucket = Util.getBucketStack(this.outputFluid.getFluid());
        this.inputStacks = Lists.newArrayList((Object[])new ItemStack[]{this.inputBucket});
        for (BlockInfo block : recipe.getTransformingBlocks()) {
            this.inputStacks.add(block.getItemStack());
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputStacks);
        ingredients.setInput(FluidStack.class, (Object)this.inputFluid);
        ingredients.setOutput(ItemStack.class, (Object)this.outputBucket);
        ingredients.setOutput(FluidStack.class, (Object)this.outputFluid);
    }

    public List<ItemStack> getInputs() {
        return this.inputStacks;
    }

    public List<ItemStack> getOutputs() {
        return ImmutableList.of((Object)this.outputBucket);
    }

    public List<FluidStack> getFluidInputs() {
        return ImmutableList.of((Object)this.inputFluid);
    }

    public List<FluidStack> getFluidOutputs() {
        return ImmutableList.of((Object)new FluidStack(this.outputFluid, 1000));
    }

    public boolean isValid() {
        return !this.inputStacks.isEmpty() && !this.outputBucket.func_190926_b();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

