/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.barrel.fluidblocktransform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import exnihilocreatio.registries.types.FluidBlockTransformer;
import exnihilocreatio.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidBlockTransformRecipe
implements IRecipeWrapper {
    @Nonnull
    private final FluidStack inputFluid;
    @Nonnull
    private final ItemStack inputBucket;
    @Nonnull
    private final List<ItemStack> inputStacks;
    @Nonnull
    private final ItemStack outputStack;

    public FluidBlockTransformRecipe(FluidBlockTransformer recipe) {
        this.inputFluid = new FluidStack(FluidRegistry.getFluid((String)recipe.getFluidName()), 1000);
        this.inputBucket = Util.getBucketStack(this.inputFluid.getFluid());
        this.inputStacks = Arrays.asList(recipe.getInput().func_193365_a());
        this.outputStack = recipe.getOutput().getItemStack();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.getInputs());
        ingredients.setInputs(FluidStack.class, this.getFluidInputs());
        ingredients.setOutput(ItemStack.class, (Object)this.outputStack);
    }

    public List<List<ItemStack>> getInputs() {
        return ImmutableList.of(Collections.singletonList(this.inputBucket), this.inputStacks);
    }

    public ItemStack getOutput() {
        return this.outputStack;
    }

    public List<FluidStack> getFluidInputs() {
        return ImmutableList.of((Object)this.inputFluid);
    }

    public boolean isValid() {
        return !this.inputBucket.func_190926_b() && !this.inputStacks.isEmpty() && !this.outputStack.func_190926_b();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

