/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.compatibility.crafttweaker.CrTIntegration;
import exnihilocreatio.compatibility.crafttweaker.prefab.ENCBaseAdd;
import exnihilocreatio.compatibility.crafttweaker.prefab.ENCBaseRemove;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilocreatio.Sieve")
@ZenRegister
public class Sieve {
    @ZenMethod
    public static void removeAll() {
        CrTIntegration.removeActions.add(new RemoveAll());
    }

    @ZenMethod
    public static void addStringMeshRecipe(IItemStack block, IItemStack drop, float chance) {
        CrTIntegration.addActions.add(new AddRecipe(block, drop, chance, BlockSieve.MeshType.STRING));
    }

    @ZenMethod
    public static void addFlintMeshRecipe(IItemStack block, IItemStack drop, float chance) {
        CrTIntegration.addActions.add(new AddRecipe(block, drop, chance, BlockSieve.MeshType.FLINT));
    }

    @ZenMethod
    public static void addIronMeshRecipe(IItemStack block, IItemStack drop, float chance) {
        CrTIntegration.addActions.add(new AddRecipe(block, drop, chance, BlockSieve.MeshType.IRON));
    }

    @ZenMethod
    public static void addDiamondMeshRecipe(IItemStack block, IItemStack drop, float chance) {
        CrTIntegration.addActions.add(new AddRecipe(block, drop, chance, BlockSieve.MeshType.DIAMOND));
    }

    private static class AddRecipe
    extends ENCBaseAdd {
        private final IItemStack itemStackIn;
        private final Block block;
        private final IItemStack drop;
        private final float chance;
        private final BlockSieve.MeshType meshType;

        AddRecipe(IItemStack block, IItemStack drop, float chance, BlockSieve.MeshType meshType) {
            Block siftBlock = Block.func_149634_a((Item)((ItemStack)block.getInternal()).func_77973_b());
            this.block = siftBlock != Blocks.field_150350_a ? siftBlock : null;
            this.drop = drop;
            this.chance = chance;
            this.meshType = meshType;
            this.itemStackIn = block;
        }

        public void apply() {
            ExNihiloRegistryManager.SIEVE_REGISTRY.register(new ItemInfo(this.block, this.itemStackIn.getDamage()), (StackInfo)new ItemInfo((ItemStack)this.drop.getInternal()), this.chance, this.meshType.getID());
        }

        public String describe() {
            if (this.block == null) {
                return "Can't add Sieve recipe for " + this.itemStackIn.toString() + " as it has no Block";
            }
            return "Adding Sieve recipe for " + this.itemStackIn.toString() + " for Mesh " + this.meshType.func_176610_l();
        }
    }

    private static class RemoveAll
    extends ENCBaseRemove {
        private RemoveAll() {
        }

        public void apply() {
            ExNihiloRegistryManager.SIEVE_REGISTRY.clearRegistry();
        }

        public String describe() {
            return "Removing all recipes for the Ex Nihilo Sieve.";
        }
    }
}

