/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.fluid;

import exnihilocreatio.barrel.BarrelFluidHandler;
import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.barrel.modes.fluid.BarrelItemHandlerFluid;
import exnihilocreatio.barrel.modes.transform.BarrelModeFluidTransform;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.FluidTransformer;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeFluid
implements IBarrelMode {
    private final BarrelItemHandlerFluid handler = new BarrelItemHandlerFluid(null);

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return stack != null;
    }

    @Override
    public String getName() {
        return "fluid";
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        if (barrel.getTank().getFluid() != null) {
            currenttip.add(barrel.getTank().getFluid().getLocalizedName());
            currenttip.add("Amount: " + String.valueOf(barrel.getTank().getFluidAmount()) + "mb");
        } else {
            currenttip.add("Empty");
        }
        return currenttip;
    }

    @Override
    public void onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            int size;
            ItemStack remainder = this.getHandler(barrel).insertItem(0, stack, false);
            int n = size = remainder.func_190926_b() ? 0 : remainder.func_190916_E();
            if (stack.func_77973_b().hasContainerItem(stack)) {
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                container.func_190920_e(stack.func_190916_E() - size);
                if (!player.field_71071_by.func_70441_a(container)) {
                    player.func_130014_f_().func_72838_d((Entity)new EntityItem(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v, container));
                }
            }
            player.func_184611_a(hand, remainder);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        return Util.getTextureFromFluidStack(barrel.getTank().getFluid());
    }

    @Override
    public Color getColorForRender() {
        return Util.whiteColor;
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        double amount = barrel.getTank().getFluidAmount();
        return (float)(amount / 1000.0 * 0.9375);
    }

    @Override
    public void update(TileBarrel barrel) {
        if (barrel.getTank().getFluid() != null) {
            BarrelFluidHandler tank = barrel.getTank();
            if (tank.getFluid() == null || tank.getFluid().amount != tank.getCapacity()) {
                return;
            }
            Fluid fluidInBarrel = tank.getFluid().getFluid();
            BlockPos barrelPos = barrel.func_174877_v();
            BlockPos pos = new BlockPos(barrelPos.func_177958_n(), barrelPos.func_177956_o() + 1, barrelPos.func_177952_p());
            Block onTop = barrel.func_145831_w().func_180495_p(pos).func_177230_c();
            Fluid fluidOnTop = null;
            if (onTop instanceof BlockLiquid) {
                Fluid fluid = fluidOnTop = onTop.func_149688_o(barrel.func_145831_w().func_180495_p(pos)) == Material.field_151586_h ? FluidRegistry.WATER : FluidRegistry.LAVA;
            }
            if (!onTop.equals(Blocks.field_150350_a) && onTop instanceof IFluidBlock) {
                fluidOnTop = ((IFluidBlock)onTop).getFluid();
            }
            if (ExNihiloRegistryManager.FLUID_ON_TOP_REGISTRY.isValidRecipe(fluidInBarrel, fluidOnTop)) {
                BlockInfo info = ExNihiloRegistryManager.FLUID_ON_TOP_REGISTRY.getTransformedBlock(fluidInBarrel, fluidOnTop);
                tank.drain(tank.getCapacity(), true);
                barrel.setMode("block");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", barrel.func_174877_v()), barrel);
                barrel.getMode().addItem(info.getItemStack(), barrel);
                return;
            }
            if (ExNihiloRegistryManager.FLUID_TRANSFORM_REGISTRY.containsKey(barrel.getTank().getFluid().getFluid().getName())) {
                List<FluidTransformer> transformers = ExNihiloRegistryManager.FLUID_TRANSFORM_REGISTRY.getFluidTransformers(barrel.getTank().getFluid().getFluid().getName());
                boolean found = false;
                for (int radius = 0; radius <= 2; ++radius) {
                    for (FluidTransformer transformer : transformers) {
                        if (ExNihiloRegistryManager.BARREL_LIQUID_BLACKLIST_REGISTRY.isBlacklisted(barrel.getTier(), transformer.getOutputFluid()) || !Util.isSurroundingBlocksAtLeastOneOf(transformer.getTransformingBlocks(), barrel.func_174877_v().func_177982_a(0, -1, 0), barrel.func_145831_w(), radius) && !Util.isSurroundingBlocksAtLeastOneOf(transformer.getTransformingBlocks(), barrel.func_174877_v(), barrel.func_145831_w(), radius)) continue;
                        FluidStack fstack = tank.getFluid();
                        tank.setFluid(null);
                        barrel.setMode("fluidTransform");
                        BarrelModeFluidTransform mode = (BarrelModeFluidTransform)barrel.getMode();
                        mode.setTransformer(transformer);
                        mode.setInputStack(fstack);
                        mode.setOutputStack(FluidRegistry.getFluidStack((String)transformer.getOutputFluid(), (int)1000));
                        PacketHandler.sendNBTUpdate(barrel);
                        found = true;
                    }
                    if (found) break;
                }
            }
        }
    }

    @Override
    public void addItem(ItemStack stack, TileBarrel barrel) {
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        return this.handler;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        BarrelFluidHandler handler = barrel.getTank();
        handler.setBarrel(barrel);
        return handler;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return true;
    }
}

