/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.compost;

import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.barrel.modes.compost.BarrelItemHandlerCompost;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.MessageCompostUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeCompost
implements IBarrelMode {
    private final Color whiteColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final BarrelItemHandlerCompost handler;
    private float fillAmount = 0.0f;
    private Color color = new Color("EEA96D");
    private Color originalColor;
    private float progress = 0.0f;
    private IBlockState compostState;

    public BarrelModeCompost() {
        this.handler = new BarrelItemHandlerCompost(null);
    }

    @Override
    public void onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemInfo info;
        if (this.fillAmount == 0.0f && !player.func_184586_b(hand).func_190926_b() && ExNihiloRegistryManager.COMPOST_REGISTRY.containsItem(info = new ItemInfo(player.func_184586_b(hand)))) {
            Compostable comp = ExNihiloRegistryManager.COMPOST_REGISTRY.getItem(info);
            this.compostState = comp.getCompostBlock().getBlockState();
            PacketHandler.sendNBTUpdate(barrel);
        }
        if (this.fillAmount < 1.0f && this.compostState != null) {
            if (!player.func_184586_b(hand).func_190926_b()) {
                ItemStack stack = player.func_184586_b(hand);
                ItemInfo info2 = new ItemInfo(player.func_184586_b(hand));
                Compostable comp = ExNihiloRegistryManager.COMPOST_REGISTRY.getItem(info2);
                if (comp == null || !comp.getCompostBlock().isValid()) {
                    return;
                }
                IBlockState testState = comp.getCompostBlock().getBlockState();
                if (ExNihiloRegistryManager.COMPOST_REGISTRY.containsItem(info2) && this.compostState.equals(testState)) {
                    Compostable compost = ExNihiloRegistryManager.COMPOST_REGISTRY.getItem(info2);
                    Color compColor = compost.getColor();
                    boolean isFirst = this.fillAmount == 0.0f;
                    this.fillAmount += compost.getValue();
                    if (this.fillAmount > 1.0f) {
                        this.fillAmount = 1.0f;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    PacketHandler.sendToAllAround(new MessageCompostUpdate(this.fillAmount, compColor, stack, this.progress, comp.getValue(), barrel.func_174877_v(), isFirst), barrel);
                    barrel.func_70296_d();
                }
            }
        } else if (this.progress >= 1.0f) {
            Util.dropItemInWorld(barrel, player, new ItemStack(this.compostState == null ? Blocks.field_150350_a : this.compostState.func_177230_c(), 1, this.compostState == null ? 0 : this.compostState.func_177230_c().func_176201_c(this.compostState)), 0.02f);
            this.removeItem(barrel);
        }
    }

    public void removeItem(TileBarrel barrel) {
        this.progress = 0.0f;
        this.fillAmount = 0.0f;
        this.color = new Color("EEA96D");
        this.handler.setStackInSlot(0, ItemStack.field_190927_a);
        this.compostState = null;
        PacketHandler.sendToAllAround(new MessageCompostUpdate(this.fillAmount, this.color, ItemStack.field_190927_a, this.progress, 0.0f, barrel.func_174877_v(), false), barrel);
        barrel.setMode("null");
        IBlockState state = barrel.func_145831_w().func_180495_p(barrel.func_174877_v());
        PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("null", barrel.func_174877_v()), barrel);
        barrel.func_145831_w().func_175656_a(barrel.func_174877_v(), state);
    }

    @Override
    public void addItem(ItemStack stack, TileBarrel barrel) {
        if (this.fillAmount < 1.0f && stack != null && !stack.func_190926_b()) {
            ItemInfo info = new ItemInfo(stack);
            Compostable comp = ExNihiloRegistryManager.COMPOST_REGISTRY.getItem(info);
            IBlockState testState = comp.getCompostBlock().getBlockState();
            if (ExNihiloRegistryManager.COMPOST_REGISTRY.containsItem(info) && this.compostState == null) {
                this.compostState = testState;
            }
            if (ExNihiloRegistryManager.COMPOST_REGISTRY.containsItem(info) && this.compostState.equals(testState)) {
                Compostable compost = ExNihiloRegistryManager.COMPOST_REGISTRY.getItem(info);
                boolean isFirst = this.fillAmount == 0.0f;
                this.fillAmount += compost.getValue();
                if (this.fillAmount > 1.0f) {
                    this.fillAmount = 1.0f;
                }
                PacketHandler.sendToAllAround(new MessageCompostUpdate(this.fillAmount, comp.getColor(), stack, this.progress, comp.getValue(), barrel.func_174877_v(), isFirst), barrel);
                barrel.func_70296_d();
            }
        }
    }

    @Override
    public void update(TileBarrel barrel) {
        if (this.fillAmount >= 1.0f && this.progress < 1.0f) {
            if (this.progress == 0.0f) {
                this.originalColor = this.color;
            }
            this.progress = (float)((double)this.progress + 1.0 / (double)ModConfig.composting.ticksToFormDirt);
            this.color = Color.average(this.originalColor, this.whiteColor, this.progress);
            PacketHandler.sendToAllAround(new MessageCompostUpdate(this.fillAmount, this.color, ItemStack.field_190927_a, this.progress, 0.0f, barrel.func_174877_v(), false), barrel);
            barrel.func_70296_d();
        }
        if (this.progress >= 1.0f && this.compostState != null) {
            barrel.setMode("block");
            PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", barrel.func_174877_v()), barrel);
            barrel.getMode().addItem(new ItemStack(this.compostState.func_177230_c(), 1, this.compostState.func_177230_c().func_176201_c(this.compostState)), barrel);
        }
    }

    @Override
    public String getName() {
        return "compost";
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        if (this.compostState != null) {
            currenttip.add("Composting " + this.compostState.func_177230_c().func_149732_F());
        }
        if (this.progress == 0.0f) {
            currenttip.add(Math.round(this.fillAmount * 100.0f) + "% full");
        } else {
            currenttip.add(Math.round(this.progress * 100.0f) + "% complete");
        }
        return currenttip;
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return ExNihiloRegistryManager.COMPOST_REGISTRY.containsItem(stack);
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74776_a("fillAmount", this.fillAmount);
        tag.func_74768_a("color", this.color.toInt());
        if (this.originalColor != null) {
            tag.func_74768_a("originalColor", this.originalColor.toInt());
        }
        tag.func_74776_a("progress", this.progress);
        if (this.compostState != null) {
            tag.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.compostState.func_177230_c())).toString());
            tag.func_74768_a("meta", this.compostState.func_177230_c().func_176201_c(this.compostState));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.fillAmount = tag.func_74760_g("fillAmount");
        this.color = new Color(tag.func_74762_e("color"));
        if (tag.func_74764_b("originalColor")) {
            this.originalColor = new Color(tag.func_74762_e("originalColor"));
        }
        this.progress = tag.func_74760_g("progress");
        if (tag.func_74764_b("block")) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("block")));
            this.compostState = block.func_176203_a(tag.func_74762_e("meta"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        if (this.compostState == null) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150346_d.func_176223_P());
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(this.compostState);
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        return this.fillAmount * 0.9375f;
    }

    @Override
    public Color getColorForRender() {
        return this.color;
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        return this.handler;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return false;
    }

    public void setFillAmount(float fillAmount) {
        this.fillAmount = fillAmount;
    }

    public float getFillAmount() {
        return this.fillAmount;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getOriginalColor() {
        return this.originalColor;
    }

    public void setOriginalColor(Color originalColor) {
        this.originalColor = originalColor;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getProgress() {
        return this.progress;
    }

    public IBlockState getCompostState() {
        return this.compostState;
    }
}

