/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class XNetWirelessChannels
extends AbstractWorldData<XNetWirelessChannels> {
    private static final String NAME = "XNetWirelessChannels";
    private final Map<WirelessChannelKey, WirelessChannelInfo> channelToWireless = new HashMap<WirelessChannelKey, WirelessChannelInfo>();
    private int cnt = 30;
    private int globalChannelVersion = 0;

    public XNetWirelessChannels(String name) {
        super(name);
    }

    public void clear() {
        this.channelToWireless.clear();
    }

    public void transmitChannel(String channel, @Nonnull IChannelType channelType, @Nullable UUID ownerUUID, int dimension, BlockPos wirelessRouterPos, NetworkId network) {
        WirelessChannelInfo channelInfo;
        WirelessChannelKey key = new WirelessChannelKey(channel, channelType, ownerUUID);
        if (this.channelToWireless.containsKey(key)) {
            channelInfo = this.channelToWireless.get(key);
        } else {
            channelInfo = new WirelessChannelInfo();
            this.channelToWireless.put(key, channelInfo);
        }
        GlobalCoordinate pos = new GlobalCoordinate(wirelessRouterPos, dimension);
        WirelessRouterInfo info = channelInfo.getRouter(pos);
        if (info == null) {
            info = new WirelessRouterInfo(pos);
            channelInfo.updateRouterInfo(pos, info);
            channelInfo.incVersion();
            this.channelUpdated();
        }
        info.setAge(0);
        info.setNetworkId(network);
        this.save();
    }

    private void channelUpdated() {
        ++this.globalChannelVersion;
    }

    public int getGlobalChannelVersion() {
        return this.globalChannelVersion;
    }

    private void dump() {
        for (Map.Entry<WirelessChannelKey, WirelessChannelInfo> entry : this.channelToWireless.entrySet()) {
            System.out.println("Channel = " + entry.getKey());
            WirelessChannelInfo channelInfo = entry.getValue();
            for (Map.Entry<GlobalCoordinate, WirelessRouterInfo> infoEntry : channelInfo.getRouters().entrySet()) {
                GlobalCoordinate pos = infoEntry.getKey();
                WirelessRouterInfo info = infoEntry.getValue();
                System.out.println("    Pos = " + BlockPosTools.toString((BlockPos)pos.getCoordinate()) + " (age " + info.age + ", net " + info.networkId.getId() + ")");
            }
        }
    }

    public void tick(World world, int amount) {
        if (this.channelToWireless.isEmpty()) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        HashSet<WirelessChannelKey> toDeleteChannel = new HashSet<WirelessChannelKey>();
        for (Map.Entry<WirelessChannelKey, WirelessChannelInfo> entry : this.channelToWireless.entrySet()) {
            WirelessChannelInfo channelInfo = entry.getValue();
            HashSet<GlobalCoordinate> toDelete = new HashSet<GlobalCoordinate>();
            for (Map.Entry<GlobalCoordinate, WirelessRouterInfo> infoEntry : channelInfo.getRouters().entrySet()) {
                WirelessRouterInfo info = infoEntry.getValue();
                int age = info.getAge();
                info.setAge(age += amount);
                if (age <= 40) continue;
                toDelete.add(infoEntry.getKey());
            }
            for (GlobalCoordinate pos : toDelete) {
                WorldBlob worldBlob = blobData.getWorldBlob(pos.getDimension());
                NetworkId networkId = channelInfo.getRouter(pos).getNetworkId();
                worldBlob.incNetworkVersion(networkId);
                channelInfo.removeRouterInfo(pos);
                channelInfo.incVersion();
            }
            if (!channelInfo.getRouters().isEmpty()) continue;
            toDeleteChannel.add(entry.getKey());
        }
        if (!toDeleteChannel.isEmpty()) {
            for (WirelessChannelKey key : toDeleteChannel) {
                this.channelToWireless.remove(key);
            }
        }
        this.save();
    }

    @Nonnull
    public static XNetWirelessChannels getWirelessChannels(World world) {
        return (XNetWirelessChannels)XNetWirelessChannels.getData((World)world, XNetWirelessChannels.class, (String)NAME);
    }

    public WirelessChannelInfo findChannel(String name, @Nonnull IChannelType channelType, @Nullable UUID owner) {
        WirelessChannelKey key = new WirelessChannelKey(name, channelType, owner);
        return this.findChannel(key);
    }

    public WirelessChannelInfo findChannel(WirelessChannelKey key) {
        return this.channelToWireless.get(key);
    }

    public Stream<WirelessChannelInfo> findChannels(@Nullable UUID owner) {
        return this.channelToWireless.entrySet().stream().filter(pair -> {
            WirelessChannelKey key = (WirelessChannelKey)pair.getKey();
            return owner == null && key.getOwner() == null || owner != null && (key.getOwner() == null || owner.equals(key.getOwner()));
        }).map(pair -> (WirelessChannelInfo)pair.getValue());
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.channelToWireless.clear();
        NBTTagList tagList = compound.func_150295_c("channels", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tc = tagList.func_150305_b(i);
            WirelessChannelInfo channelInfo = new WirelessChannelInfo();
            this.readRouters(tc.func_150295_c("routers", 10), channelInfo);
            UUID owner = null;
            if (tc.func_186855_b("owner")) {
                owner = tc.func_186857_a("owner");
            }
            String name = tc.func_74779_i("name");
            IChannelType type = XNet.xNetApi.findType(tc.func_74779_i("type"));
            this.channelToWireless.put(new WirelessChannelKey(name, type, owner), channelInfo);
        }
    }

    private void readRouters(NBTTagList tagList, WirelessChannelInfo channelInfo) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tc = tagList.func_150305_b(i);
            GlobalCoordinate pos = new GlobalCoordinate(new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z")), tc.func_74762_e("dim"));
            WirelessRouterInfo info = new WirelessRouterInfo(pos);
            info.setAge(tc.func_74762_e("age"));
            info.setNetworkId(new NetworkId(tc.func_74762_e("network")));
            channelInfo.updateRouterInfo(pos, info);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList channelTagList = new NBTTagList();
        for (Map.Entry<WirelessChannelKey, WirelessChannelInfo> entry : this.channelToWireless.entrySet()) {
            NBTTagCompound channelTc = new NBTTagCompound();
            WirelessChannelInfo channelInfo = entry.getValue();
            WirelessChannelKey key = entry.getKey();
            channelTc.func_74778_a("name", key.getName());
            channelTc.func_74778_a("type", key.getChannelType().getID());
            if (key.getOwner() != null) {
                channelTc.func_186854_a("owner", key.getOwner());
            }
            channelTc.func_74782_a("routers", (NBTBase)this.writeRouters(channelInfo));
            channelTagList.func_74742_a((NBTBase)channelTc);
        }
        compound.func_74782_a("channels", (NBTBase)channelTagList);
        return compound;
    }

    private NBTTagList writeRouters(WirelessChannelInfo channelInfo) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<GlobalCoordinate, WirelessRouterInfo> infoEntry : channelInfo.getRouters().entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            GlobalCoordinate pos = infoEntry.getKey();
            tc.func_74768_a("dim", pos.getDimension());
            tc.func_74768_a("x", pos.getCoordinate().func_177958_n());
            tc.func_74768_a("y", pos.getCoordinate().func_177956_o());
            tc.func_74768_a("z", pos.getCoordinate().func_177952_p());
            WirelessRouterInfo info = infoEntry.getValue();
            tc.func_74768_a("age", info.getAge());
            tc.func_74768_a("network", info.getNetworkId().getId());
            tagList.func_74742_a((NBTBase)tc);
        }
        return tagList;
    }

    public static class WirelessRouterInfo {
        private int age = 0;
        private NetworkId networkId;
        private final GlobalCoordinate coordinate;

        public WirelessRouterInfo(GlobalCoordinate coordinate) {
            this.coordinate = coordinate;
        }

        public NetworkId getNetworkId() {
            return this.networkId;
        }

        public void setNetworkId(NetworkId networkId) {
            this.networkId = networkId;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public GlobalCoordinate getCoordinate() {
            return this.coordinate;
        }
    }

    public static class WirelessChannelInfo {
        private final Map<GlobalCoordinate, WirelessRouterInfo> routers = new HashMap<GlobalCoordinate, WirelessRouterInfo>();
        private int version = 0;

        public void updateRouterInfo(GlobalCoordinate pos, WirelessRouterInfo info) {
            this.routers.put(pos, info);
        }

        public void removeRouterInfo(GlobalCoordinate pos) {
            this.routers.remove(pos);
        }

        public WirelessRouterInfo getRouter(GlobalCoordinate pos) {
            return this.routers.get(pos);
        }

        public Map<GlobalCoordinate, WirelessRouterInfo> getRouters() {
            return this.routers;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void incVersion() {
            ++this.version;
        }
    }
}

