/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.cables;

import cofh.redstoneflux.api.IEnergyReceiver;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.xnet.api.tiles.IConnectorTile;
import mcjty.xnet.blocks.facade.IFacadeSupport;
import mcjty.xnet.blocks.facade.MimicBlockSupport;
import mcjty.xnet.config.GeneralConfiguration;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")})
public class ConnectorTileEntity
extends GenericTileEntity
implements IEnergyReceiver,
IFacadeSupport,
IConnectorTile {
    public static final String CMD_ENABLE = "connector.enable";
    public static final Key<Integer> PARAM_FACING = new Key("facing", Type.INTEGER);
    public static final Key<Boolean> PARAM_ENABLED = new Key("enabled", Type.BOOLEAN);
    private MimicBlockSupport mimicBlockSupport = new MimicBlockSupport();
    private int energy = 0;
    private int[] inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
    private String name = "";
    private int pulseCounter;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private byte enabled = (byte)63;
    private Block[] cachedNeighbours = new Block[EnumFacing.field_82609_l.length];
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    private IEnergyStorage[] sidedHandlers = new IEnergyStorage[6];

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getConnectorName, this::setConnectorName)};
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        IBlockState oldMimicBlock = this.mimicBlockSupport.getMimicBlock();
        byte oldEnabled = this.enabled;
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K && (this.enabled != oldEnabled || this.mimicBlockSupport.getMimicBlock() != oldMimicBlock)) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public int getPowerOut(EnumFacing side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(EnumFacing side, int powerOut) {
        if (powerOut > 15) {
            powerOut = 15;
        }
        if (this.powerOut[side.ordinal()] == powerOut) {
            return;
        }
        this.powerOut[side.ordinal()] = powerOut;
        this.func_70296_d();
        this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(side), this.func_145838_q(), this.field_174879_c);
    }

    public void setEnabled(EnumFacing direction, boolean e) {
        this.enabled = e ? (byte)(this.enabled | 1 << direction.ordinal()) : (byte)(this.enabled & ~(1 << direction.ordinal()));
        this.markDirtyClient();
    }

    public boolean isEnabled(EnumFacing direction) {
        return (this.enabled & 1 << direction.ordinal()) != 0;
    }

    @Override
    public IBlockState getMimicBlock() {
        return this.mimicBlockSupport.getMimicBlock();
    }

    public void setMimicBlock(IBlockState mimicBlock) {
        this.mimicBlockSupport.setMimicBlock(mimicBlock);
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel == 0 && powered > 0) {
            ++this.pulseCounter;
        }
        super.setPowerInput(powered);
    }

    @Override
    public int getPulseCounter() {
        return this.pulseCounter;
    }

    public void possiblyMarkNetworkDirty(@Nonnull BlockPos neighbor) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.func_174877_v().func_177972_a(facing).equals((Object)neighbor)) continue;
            Block newblock = this.field_145850_b.func_180495_p(neighbor).func_177230_c();
            if (newblock != this.cachedNeighbours[facing.ordinal()]) {
                this.cachedNeighbours[facing.ordinal()] = newblock;
                WorldBlob worldBlob = XNetBlobData.getBlobData(this.field_145850_b).getWorldBlob(this.field_145850_b);
                worldBlob.incNetworkVersion(worldBlob.getNetworkAt(this.func_174877_v()));
            }
            return;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.energy = tagCompound.func_74762_e("energy");
        this.inputFromSide = tagCompound.func_74759_k("inputs");
        if (this.inputFromSide.length != 6) {
            this.inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.mimicBlockSupport.readFromNBT(tagCompound);
        this.pulseCounter = tagCompound.func_74762_e("pulse");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.func_74779_i("name");
        this.enabled = tagCompound.func_74764_b("enabled") ? tagCompound.func_74771_c("enabled") : (byte)63;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("energy", this.energy);
        tagCompound.func_74783_a("inputs", this.inputFromSide);
        this.mimicBlockSupport.writeToNBT(tagCompound);
        tagCompound.func_74768_a("pulse", this.pulseCounter);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74778_a("name", this.name);
        tagCompound.func_74774_a("enabled", this.enabled);
    }

    @Override
    public int getPowerLevel() {
        return this.powerLevel;
    }

    public void setConnectorName(String n) {
        this.name = n;
        this.markDirtyClient();
    }

    public String getConnectorName() {
        return this.name;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        if (this.energy != energy) {
            if (energy < 0) {
                energy = 0;
            }
            this.energy = energy;
            this.markDirtyQuick();
        }
    }

    public void setEnergyInputFrom(EnumFacing from, int rate) {
        if (this.inputFromSide[from.ordinal()] != rate) {
            this.inputFromSide[from.ordinal()] = rate;
            this.markDirtyQuick();
        }
    }

    public int getMaxEnergy() {
        return GeneralConfiguration.maxRfConnector;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.receiveEnergyInternal(from, maxReceive, simulate);
    }

    private int receiveEnergyInternal(EnumFacing from, int maxReceive, boolean simulate) {
        if (from == null) {
            return 0;
        }
        int m = this.inputFromSide[from.ordinal()];
        if (m > 0) {
            int toreceive = Math.min(maxReceive, m);
            int newenergy = this.energy + toreceive;
            if (newenergy > this.getMaxEnergy()) {
                toreceive -= newenergy - this.getMaxEnergy();
                newenergy = this.getMaxEnergy();
            }
            if (!simulate && this.energy != newenergy) {
                this.energy = newenergy;
                this.inputFromSide[from.ordinal()] = 0;
                this.markDirtyQuick();
            }
            return toreceive;
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return this.energy;
    }

    private int getEnergyStoredInternal() {
        return this.energy;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergy();
    }

    private int getMaxEnergyStoredInternal() {
        return this.getMaxEnergy();
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        if (from == null) {
            return false;
        }
        return this.inputFromSide[from.ordinal()] > 0;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ENABLE.equals(command)) {
            int f = (Integer)params.get(PARAM_FACING);
            boolean e = (Boolean)params.get(PARAM_ENABLED);
            this.setEnabled(EnumFacing.field_82609_l[f], e);
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == null) {
                return null;
            }
            if (this.sidedHandlers[facing.ordinal()] == null) {
                this.createSidedHandler(facing);
            }
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.sidedHandlers[facing.ordinal()]);
        }
        return (T)super.getCapability(capability, facing);
    }

    private void createSidedHandler(final EnumFacing facing) {
        class SidedHandler
        implements IEnergyStorage {
            SidedHandler() {
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return ConnectorTileEntity.this.receiveEnergyInternal(facing, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return ConnectorTileEntity.this.getEnergyStoredInternal();
            }

            public int getMaxEnergyStored() {
                return ConnectorTileEntity.this.getMaxEnergyStoredInternal();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        }
        this.sidedHandlers[facing.ordinal()] = new SidedHandler();
    }
}

