/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.packets.PacketErrorUpdateEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class ContainerEntity<T extends Entity>
extends ContainerForestry {
    protected final T entity;
    @Nullable
    private ImmutableSet<IErrorState> previousErrorStates;

    protected ContainerEntity(T entity) {
        this.entity = entity;
    }

    protected ContainerEntity(T entity, InventoryPlayer playerInventory, int xInv, int yInv) {
        this(entity);
        this.addPlayerInventory(playerInventory, xInv, yInv);
    }

    @Override
    protected final boolean canAccess(EntityPlayer player) {
        return true;
    }

    public final boolean func_75145_c(EntityPlayer entityplayer) {
        return ((IInventory)this.entity).func_70300_a(entityplayer);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.entity instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.entity;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (this.previousErrorStates == null || !errorStates.equals(this.previousErrorStates)) {
                PacketErrorUpdateEntity packet = new PacketErrorUpdateEntity((Entity)this.entity, errorLogicSource);
                this.sendPacketToListeners(packet);
            }
            this.previousErrorStates = errorStates;
        }
    }
}

