/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.blocks.IWProperties;
import malte0811.industrialwires.mech_mb.EUCapability;
import malte0811.industrialwires.mech_mb.IMBPartElectric;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechMBPart;
import malte0811.industrialwires.mech_mb.Waveform;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.util.MBSideConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class MechPartEnergyIO
extends MechMBPart
implements IMBPartElectric {
    private double bufferToMB;
    private Waveform wfToMB = Waveform.forParameters(Waveform.Type.NONE, Waveform.Phases.get(this.has4Phases()), Waveform.Speed.ROTATION);
    private double bufferToWorld;
    private Waveform wfToWorld = Waveform.forParameters(Waveform.Type.NONE, Waveform.Phases.get(this.has4Phases()), Waveform.Speed.ROTATION);
    private final IEnergyStorage[] capForge = new IEnergyStorage[]{new EnergyStorageMMB(IEEnums.SideConfig.INPUT), new EnergyStorageMMB(IEEnums.SideConfig.OUTPUT)};
    private final EUCapability.IC2EnergyHandler[] capIc2 = new EUCapability.IC2EnergyHandler[]{new IC2EHandlerMB(IEEnums.SideConfig.INPUT), new IC2EHandlerMB(IEEnums.SideConfig.OUTPUT)};
    private MBSideConfig sides = new MBSideConfig(this.getEnergyConnections());

    @Override
    public Waveform getProduced(MechEnergy state) {
        return this.transform(this.wfToMB, state);
    }

    protected Waveform transform(Waveform wf, MechEnergy e) {
        return wf;
    }

    protected double getTransformationLimit(MechEnergy me) {
        return 1.0;
    }

    @Override
    public double getAvailableEEnergy(MechEnergy energy) {
        return this.bufferToMB * this.getTransformationLimit(energy);
    }

    @Override
    public void extractEEnergy(double eEnergy, MechEnergy mEnergy) {
        if (eEnergy > 0.0) {
            this.bufferToMB -= eEnergy / this.getTransformationLimit(mEnergy);
        }
    }

    @Override
    public double requestEEnergy(Waveform waveform, MechEnergy energy) {
        Waveform transformed = this.transform(waveform, energy);
        if (!this.has4Phases() == transformed.isSinglePhase()) {
            double ret = this.getMaxBuffer() - this.bufferToWorld;
            return ret * this.getTransformationLimit(energy);
        }
        return 0.0;
    }

    @Override
    public void insertEEnergy(double given, Waveform waveform, MechEnergy mechEnergy) {
        this.wfToWorld = this.transform(waveform, mechEnergy);
        this.bufferToWorld += given;
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing side, BlockPos pos) {
        MBSideConfig.BlockFace s = new MBSideConfig.BlockFace(pos, side);
        IEEnums.SideConfig conf = this.sides.getConfigForFace(s);
        if (conf != IEEnums.SideConfig.NONE) {
            if (cap == EUCapability.ENERGY_IC2) {
                return (T)EUCapability.ENERGY_IC2.cast((Object)this.capIc2[conf.ordinal() - 1]);
            }
            if (cap == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.capForge[conf.ordinal() - 1]);
            }
        }
        return super.getCapability(cap, side, pos);
    }

    @Override
    public <T> boolean hasCapability(Capability<T> cap, EnumFacing side, BlockPos pos) {
        if (this.sides.getConfigForFace(new MBSideConfig.BlockFace(pos, side)) != IEEnums.SideConfig.NONE) {
            if (cap == EUCapability.ENERGY_IC2) {
                return true;
            }
            if (cap == CapabilityEnergy.ENERGY) {
                return true;
            }
        }
        return super.hasCapability(cap, side, pos);
    }

    @Override
    public void createMEnergy(MechEnergy e) {
    }

    @Override
    public double requestMEnergy(MechEnergy e) {
        return 0.0;
    }

    @Override
    public void insertMEnergy(double added) {
        int available = (int)Math.min(ConversionUtil.ifPerJoule() * this.bufferToWorld, this.getMaxBuffer() / (double)this.getEnergyConnections().size());
        if (available > 0 && this.wfToWorld.isAC()) {
            this.bufferToWorld -= this.outputFE(available);
        }
    }

    @Override
    public double getInertia() {
        return 50.0;
    }

    @Override
    public double getMaxSpeed() {
        return IWConfig.MechConversion.allowMBEU() ? 100.0 : -1.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound out) {
        out.func_74780_a("inBuffer", this.bufferToMB);
        out.func_74780_a("outBuffer", this.bufferToWorld);
        out.func_74778_a("inBufferWf", this.wfToMB.toString());
        out.func_74778_a("outBufferWf", this.wfToWorld.toString());
        out.func_74782_a("sideConfig", (NBTBase)this.sides.toNBT(this.getEnergyConnections()));
    }

    @Override
    public void readFromNBT(NBTTagCompound in) {
        this.bufferToMB = in.func_74769_h("inBuffer");
        this.bufferToWorld = in.func_74769_h("outBuffer");
        this.wfToMB = Waveform.fromString(in.func_74779_i("inBufferWf"));
        this.wfToWorld = Waveform.fromString(in.func_74779_i("outBufferWf"));
        this.sides = new MBSideConfig(this.getEnergyConnections(), in.func_150295_c("sideConfig", 3));
    }

    @Override
    public int interact(@Nonnull EnumFacing side, @Nonnull Vec3i offset, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem) {
        MBSideConfig.BlockFace s;
        if (Utils.isHammer((ItemStack)heldItem) && this.sides.isValid(s = new MBSideConfig.BlockFace(new BlockPos(offset), side))) {
            if (!this.world.isRemote) {
                this.sides.cycleSide(s);
                this.world.markForUpdate(BlockPos.field_177992_a);
            }
            return 3;
        }
        return -1;
    }

    @Override
    public IBlockState getExtState(IBlockState in) {
        if ((in = super.getExtState(in)) instanceof IExtendedBlockState) {
            in = ((IExtendedBlockState)in).withProperty(IWProperties.MB_SIDES, (Object)this.sides);
        }
        return in;
    }

    protected abstract double getMaxBuffer();

    protected abstract boolean has4Phases();

    public abstract List<MBSideConfig.BlockFace> getEnergyConnections();

    private double outputFE(int available) {
        double extracted = 0.0;
        for (MBSideConfig.BlockFace output : this.getEnergyConnections()) {
            IEnergyStorage energy;
            if (output.face == null || this.sides.getConfigForFace(output) != IEEnums.SideConfig.OUTPUT) continue;
            BlockPos outTE = output.offset.func_177972_a(output.face);
            TileEntity te = this.world.getTileEntity(outTE);
            EnumFacing sideReal = this.world.transformedToReal(output.face).func_176734_d();
            if (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, sideReal) || (energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, sideReal)) == null || !energy.canReceive()) continue;
            int received = energy.receiveEnergy(available, false);
            available -= received;
            extracted += ConversionUtil.joulesPerIf() * (double)received;
        }
        return extracted;
    }

    class EnergyStorageMMB
    implements IEnergyStorage {
        private IEEnums.SideConfig type;

        EnergyStorageMMB(IEEnums.SideConfig type) {
            this.type = type;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.type != IEEnums.SideConfig.INPUT) {
                return 0;
            }
            double buffer = MechPartEnergyIO.this.bufferToMB;
            double input = (double)maxReceive * ConversionUtil.joulesPerIf();
            if (!MechPartEnergyIO.this.wfToMB.isAC()) {
                buffer = 0.0;
            }
            input = Math.min(input, MechPartEnergyIO.this.getMaxBuffer() - buffer);
            buffer += input;
            if (!simulate) {
                MechPartEnergyIO.this.bufferToMB = buffer;
                MechPartEnergyIO.this.wfToMB = Waveform.forParameters(Waveform.Type.AC, Waveform.Phases.get(MechPartEnergyIO.this.has4Phases()), Waveform.Speed.EXTERNAL);
            }
            return (int)(ConversionUtil.ifPerJoule() * input);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!MechPartEnergyIO.this.wfToWorld.isAC() || this.type != IEEnums.SideConfig.OUTPUT) {
                return 0;
            }
            double buffer = MechPartEnergyIO.this.bufferToWorld;
            double output = (double)maxExtract * ConversionUtil.joulesPerIf();
            output = Math.min(output, buffer);
            buffer -= output;
            if (!simulate) {
                MechPartEnergyIO.this.bufferToWorld = buffer;
            }
            return (int)(ConversionUtil.ifPerJoule() * output);
        }

        public int getEnergyStored() {
            return (int)(ConversionUtil.ifPerJoule() * (MechPartEnergyIO.this.bufferToWorld + MechPartEnergyIO.this.bufferToMB));
        }

        public int getMaxEnergyStored() {
            return (int)(2.0 * ConversionUtil.ifPerJoule() * MechPartEnergyIO.this.getMaxBuffer());
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    class IC2EHandlerMB
    extends EUCapability.IC2EnergyHandler {
        private IEEnums.SideConfig type;

        IC2EHandlerMB(IEEnums.SideConfig type) {
            this.tier = 3;
            this.type = type;
        }

        @Override
        public double injectEnergy(EnumFacing side, double amount, double voltage) {
            double buffer = MechPartEnergyIO.this.bufferToMB;
            double input = amount * ConversionUtil.joulesPerEu();
            if (!MechPartEnergyIO.this.wfToMB.isDC()) {
                buffer = 0.0;
            }
            input = Math.min(input, MechPartEnergyIO.this.getMaxBuffer() - buffer);
            MechPartEnergyIO.this.bufferToMB = (buffer += input);
            MechPartEnergyIO.this.wfToMB = Waveform.forParameters(Waveform.Type.DC, Waveform.Phases.get(MechPartEnergyIO.this.has4Phases()), Waveform.Speed.EXTERNAL);
            return amount - ConversionUtil.euPerJoule() * input;
        }

        @Override
        public double getOfferedEnergy() {
            if (MechPartEnergyIO.this.wfToWorld.isDC() && this.type == IEEnums.SideConfig.OUTPUT) {
                return Math.min(ConversionUtil.euPerJoule() * MechPartEnergyIO.this.bufferToWorld, ConversionUtil.euPerJoule() * MechPartEnergyIO.this.getMaxBuffer()) / (double)MechPartEnergyIO.this.getEnergyConnections().size();
            }
            return 0.0;
        }

        @Override
        public double getDemandedEnergy() {
            if (this.type == IEEnums.SideConfig.INPUT) {
                return Math.min(ConversionUtil.euPerJoule() * (MechPartEnergyIO.this.getMaxBuffer() - MechPartEnergyIO.this.bufferToMB), ConversionUtil.euPerJoule() * MechPartEnergyIO.this.getMaxBuffer()) / (double)MechPartEnergyIO.this.getEnergyConnections().size();
            }
            return 0.0;
        }

        @Override
        public void drawEnergy(double amount) {
            MechPartEnergyIO.this.bufferToWorld = MechPartEnergyIO.this.bufferToWorld - ConversionUtil.joulesPerEu() * amount;
        }
    }
}

