/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class Variac
extends PanelComponent
implements IConfigurableComponent {
    private static final float SIZE = 0.1875f;
    private static final float innerSize = (float)(Math.sqrt(2.0) / 2.0 * 0.1875);
    private static final float offset = (0.1875f - innerSize) / 2.0f;
    private static final float[] darkGray = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    private static final float[] white = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float rodDia = 0.03125f;
    private static final float rodOffset = 0.078125f;
    private static final float arrowSize = 0.03125f;
    private int out;
    @Nonnull
    private ControlPanelNetwork.RSChannel primary = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    @Nonnull
    private ControlPanelNetwork.RSChannel secondary = ControlPanelNetwork.RSChannel.INVALID_CHANNEL;

    public Variac(@Nonnull ControlPanelNetwork.RSChannel primary, @Nonnull ControlPanelNetwork.RSChannel secondary) {
        this();
        this.primary = primary;
        this.secondary = secondary;
    }

    public Variac() {
        super("variac");
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        if (!toItem) {
            nbt.func_74768_a("output", this.out);
        }
        nbt.func_74768_a("rsId", this.primary.getController());
        nbt.func_74774_a("rsChannel", this.primary.getColor());
        nbt.func_74768_a("rsId2", this.secondary.getController());
        nbt.func_74774_a("rsChannel2", this.secondary.getColor());
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        this.out = nbt.func_74762_e("output");
        int rsController = nbt.func_74762_e("rsId");
        byte rsColor = nbt.func_74771_c("rsChannel");
        this.primary = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        if (nbt.func_74764_b("rsId2")) {
            rsController = nbt.func_74762_e("rsId2");
            rsColor = nbt.func_74771_c("rsChannel2");
            this.secondary = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        } else {
            this.secondary = ControlPanelNetwork.RSChannel.INVALID_CHANNEL;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>();
        float angle = -((float)(Math.PI * 2 * (8.5 + (double)this.out) / 272.0));
        Matrix4 mat = new Matrix4();
        mat.translate(0.09375, 0.0, 0.09375);
        mat.rotate((double)angle, 0.0, 1.0, 0.0);
        mat.translate(-0.09375, 0.0, -0.09375);
        PanelUtils.addColoredBox(darkGray, darkGray, null, new Vector3f(offset, this.getHeight() / 2.0f, offset), new Vector3f(innerSize, this.getHeight() / 2.0f, innerSize), ret, false, mat);
        PanelUtils.addColoredBox(GRAY, GRAY, null, new Vector3f(0.078125f, 0.0f, 0.078125f), new Vector3f(0.03125f, this.getHeight() / 2.0f, 0.03125f), ret, false, mat);
        mat.translate(0.09375, 0.0, 0.09375);
        mat.rotate(0.7853981633974483, 0.0, 1.0, 0.0);
        mat.translate(-0.09375, 0.0, -0.09375);
        PanelUtils.addColoredBox(darkGray, darkGray, null, new Vector3f(offset, this.getHeight() / 2.0f, offset), new Vector3f(innerSize, this.getHeight() / 2.0f, innerSize), ret, false, mat);
        mat.translate(0.09375, 0.0, 0.09375);
        mat.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
        mat.translate(-0.09375, (double)0.001f, -0.09375);
        PanelUtils.addColoredQuad(ret, new Vector3f(offset, this.getHeight(), offset), new Vector3f(offset, this.getHeight(), offset), new Vector3f(offset + 0.015625f, this.getHeight(), offset + 0.03125f), new Vector3f(offset + 0.03125f, this.getHeight(), offset + 0.015625f), EnumFacing.UP, white, mat);
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        Variac ret = new Variac(this.primary, this.secondary);
        ret.out = this.out;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + 0.1875f), (double)this.getHeight(), (double)(this.y + 0.1875f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
        double yRel = -(hitRelative.field_72449_c - 0.09375);
        double xRel = hitRelative.field_72450_a - 0.09375;
        double angle = 4.71238898038469 - Math.atan2(yRel, xRel);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        } else if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        int step = this.secondary.isValid() && player.func_70093_af() ? 1 : 16;
        int newLevel = (int)(((angle /= Math.PI * 2) - 0.029411764815449715) * 17.0 * 16.0);
        int diff = Math.abs(newLevel - this.out);
        if (diff > step) {
            if (newLevel > this.out) {
                newLevel = this.out + step;
            } else if (newLevel < this.out) {
                newLevel = this.out - step;
            }
        }
        if ((newLevel = Math.max(0, Math.min(newLevel, 255))) != this.out) {
            this.setOut(newLevel);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.primary, (byte)(this.out >> 4)));
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.secondary, (byte)(this.out & 0xF)));
    }

    @Override
    public float getHeight() {
        return 0.0625f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        int left = (int)Math.ceil((double)gui.getX0() + ((double)offset + aabb.field_72340_a) * (double)gui.panelSize);
        int top = (int)Math.ceil((double)gui.getY0() + ((double)offset + aabb.field_72339_c) * (double)gui.panelSize);
        int right = (int)Math.floor((double)gui.getX0() + (aabb.field_72336_d - (double)offset) * (double)gui.panelSize);
        int bottom = (int)Math.floor((double)gui.getY0() + (aabb.field_72334_f - (double)offset) * (double)gui.panelSize);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((left + right) / 2), (float)((top + bottom) / 2), (float)0.0f);
        GlStateManager.func_179114_b((float)21.17647f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-(left + right) / 2), (float)(-(top + bottom) / 2), (float)0.0f);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-13421773);
        GlStateManager.func_179109_b((float)((left + right) / 2), (float)((top + bottom) / 2), (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-(left + right) / 2), (float)(-(top + bottom) / 2), (float)0.0f);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-13421773);
        GlStateManager.func_179121_F();
    }

    public void setOut(int value) {
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.primary, (byte)(value >> 4)));
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.secondary, (byte)(value & 0xF)));
        this.out = value;
        this.panel.func_70296_d();
        this.panel.triggerRenderUpdate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Variac variac = (Variac)o;
        if (this.out != variac.out) {
            return false;
        }
        if (!this.primary.equals(variac.primary)) {
            return false;
        }
        return this.secondary.equals(variac.secondary);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.out;
        result = 31 * result + this.primary.hashCode();
        result = 31 * result + this.secondary.hashCode();
        return result;
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case RS_CHANNEL: {
                if (id == 0) {
                    this.primary = this.primary.withColor(value);
                    break;
                }
                this.secondary = this.secondary.withColor(value);
                break;
            }
            case INT: {
                if (id == 0) {
                    this.primary = this.primary.withController(value);
                    break;
                }
                this.secondary = this.secondary.withController(value);
            }
        }
    }

    @Override
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)("industrialwires.desc.rschannel_info" + (id == 1 ? "2" : "")), (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)("industrialwires.desc.rsid_info" + (id == 1 ? "2" : "")), (Object[])new Object[0]);
            }
        }
        return "INVALID?";
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.primary.getColor()), new IConfigurableComponent.RSColorConfig("channel2", 90, 0, this.secondary.getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 50, this.primary.getController(), 2, false), new IConfigurableComponent.IntConfig("rsId2", 90, 50, this.secondary.getController(), 2, true)};
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }
}

