/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.client.ClientUtilsIW;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PropertyComponents;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public final class PanelUtils {
    public static TextureAtlasSprite PANEL_TEXTURE;
    public static Item PANEL_ITEM;
    private static ItemStack panelBase;
    private static final float[] UV_FULL;
    private static final float[] WHITE;

    private PanelUtils() {
    }

    @SideOnly(value=Side.CLIENT)
    public static List<BakedQuad> generateQuads(PropertyComponents.PanelRenderProperties components) {
        if (PANEL_TEXTURE == null) {
            PANEL_TEXTURE = Minecraft.func_71410_x().func_147117_R().func_110572_b("industrialwires:blocks/control_panel");
        }
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        Matrix4 m4 = components.getPanelTopTransform();
        Matrix4 m4RotOnly = m4.copy();
        m4RotOnly.invert();
        m4RotOnly.transpose();
        for (int i = 0; i < components.size(); ++i) {
            PanelComponent pc = (PanelComponent)components.get(i);
            Matrix4 m4Here = m4.copy().translate((double)pc.getX(), (double)0.001f, (double)pc.getY());
            List<RawQuad> compQuads = pc.getQuads();
            for (RawQuad bq : compQuads) {
                ret.add(ClientUtilsIW.bakeQuad(bq, m4Here, m4RotOnly));
            }
        }
        Matrix4 baseTrans = components.getPanelBaseTransform();
        Matrix4 baseNorm = baseTrans.copy();
        baseNorm.invert();
        baseNorm.transpose();
        ArrayList<RawQuad> rawOut = new ArrayList<RawQuad>();
        float height1 = PanelUtils.getLocalHeightFromZ(1.0, components.getHeight(), components.getAngle());
        float height0 = PanelUtils.getLocalHeightFromZ(0.0, components.getHeight(), components.getAngle());
        float vMax1 = 16.0f * height1;
        float vMax0 = 16.0f * height0;
        float xMin = 0.0f;
        float xMax = 1.0f;
        float zMin = 0.0f;
        float zMax = 1.0f;
        if (components instanceof PropertyComponents.AABBPanelProperties) {
            AxisAlignedBB xzAABB = ((PropertyComponents.AABBPanelProperties)components).getPanelBoundingBox();
            xMin = (float)xzAABB.field_72340_a;
            zMin = (float)xzAABB.field_72339_c;
            xMax = (float)xzAABB.field_72336_d;
            zMax = (float)xzAABB.field_72334_f;
        }
        float uMaxX = 16.0f * (xMax - xMin);
        float uMaxZ = 16.0f * (zMax - zMin);
        rawOut.add(new RawQuad(new Vector3f(xMin, height0, zMin), new Vector3f(xMin, height1, zMax), new Vector3f(xMax, height1, zMax), new Vector3f(xMax, height0, zMin), EnumFacing.UP, PANEL_TEXTURE, WHITE, null, new float[]{0.0f, 0.0f, uMaxX, uMaxZ}, -1));
        rawOut.add(new RawQuad(new Vector3f(xMin, 0.0f, zMin), new Vector3f(xMax, 0.0f, zMin), new Vector3f(xMax, 0.0f, zMax), new Vector3f(xMin, 0.0f, zMax), EnumFacing.DOWN, PANEL_TEXTURE, WHITE, null, UV_FULL, -1));
        rawOut.add(new RawQuad(new Vector3f(xMin, 0.0f, zMin), new Vector3f(xMin, 0.0f, zMax), new Vector3f(xMin, height1, zMax), new Vector3f(xMin, height0, zMin), EnumFacing.UP, PANEL_TEXTURE, WHITE, null, new float[][]{{0.0f, 0.0f}, {0.0f, uMaxZ}, {vMax1, uMaxZ}, {vMax0, 0.0f}}, -1));
        rawOut.add(new RawQuad(new Vector3f(xMax, 0.0f, zMin), new Vector3f(xMax, height0, zMin), new Vector3f(xMax, height1, zMax), new Vector3f(xMax, 0.0f, zMax), EnumFacing.UP, PANEL_TEXTURE, WHITE, null, new float[][]{{0.0f, 0.0f}, {vMax0, 0.0f}, {vMax1, uMaxZ}, {0.0f, uMaxZ}}, -1));
        rawOut.add(new RawQuad(new Vector3f(xMax, 0.0f, zMin), new Vector3f(xMin, 0.0f, zMin), new Vector3f(xMin, height0, zMin), new Vector3f(xMax, height0, zMin), EnumFacing.UP, PANEL_TEXTURE, WHITE, null, new float[]{0.0f, 0.0f, vMax0, uMaxX}, -1));
        rawOut.add(new RawQuad(new Vector3f(xMin, 0.0f, zMax), new Vector3f(xMax, 0.0f, zMax), new Vector3f(xMax, height1, zMax), new Vector3f(xMin, height1, zMax), EnumFacing.UP, PANEL_TEXTURE, WHITE, null, new float[]{0.0f, 0.0f, vMax1, uMaxX}, -1));
        for (RawQuad bq : rawOut) {
            ret.add(ClientUtilsIW.bakeQuad(bq, baseTrans, baseNorm));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public static void putVertexData(VertexFormat format, UnpackedBakedQuad.Builder builder, Vector3f pos, OBJModel.Normal faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colorA) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{pos.getX(), pos.getY(), pos.getZ(), 0.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{colorA[0], colorA[1], colorA[2], colorA[3]});
                    continue block6;
                }
                case UV: {
                    if (sprite == null) {
                        sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    }
                    builder.put(e, new float[]{sprite.func_94214_a(u), sprite.func_94207_b(v), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addTexturedBox(Vector3f min, Vector3f size, List<RawQuad> out, float[] uvs, TextureAtlasSprite tex) {
        PanelUtils.addBox(WHITE, WHITE, WHITE, min, size, out, true, uvs, tex, null, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addColoredBox(float[] colorTop, float[] colorSides, float[] colorBottom, Vector3f min, Vector3f size, List<RawQuad> out, boolean doBottom) {
        PanelUtils.addBox(colorTop, colorSides, colorBottom, min, size, out, doBottom, UV_FULL, (TextureAtlasSprite)ModelLoader.White.INSTANCE, null, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addColoredBox(float[] colorTop, float[] colorSides, float[] colorBottom, Vector3f min, Vector3f size, List<RawQuad> out, boolean doBottom, @Nullable Matrix4 mat) {
        PanelUtils.addBox(colorTop, colorSides, colorBottom, min, size, out, doBottom, UV_FULL, (TextureAtlasSprite)ModelLoader.White.INSTANCE, mat, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addColoredBox(float[] colorTop, float[] colorSides, float[] colorBottom, Vector3f min, Vector3f size, List<RawQuad> out, boolean doBottom, @Nullable Matrix4 mat, boolean inside) {
        PanelUtils.addBox(colorTop, colorSides, colorBottom, min, size, out, doBottom, UV_FULL, (TextureAtlasSprite)ModelLoader.White.INSTANCE, mat, inside);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addBox(float[] colorTop, float[] colorSides, float[] colorBottom, Vector3f min, Vector3f size, List<RawQuad> out, boolean doBottom, float[] uvs, TextureAtlasSprite tex, @Nullable Matrix4 mat, boolean inside) {
        PanelUtils.addQuad(out, new Vector3f(min.x, min.y + size.y, min.z), new Vector3f(min.x, min.y + size.y, min.z + size.z), new Vector3f(min.x + size.x, min.y + size.y, min.z + size.z), new Vector3f(min.x + size.x, min.y + size.y, min.z), EnumFacing.UP, colorTop, tex, uvs, mat, inside);
        if (doBottom) {
            PanelUtils.addQuad(out, new Vector3f(min.x, min.y, min.z), new Vector3f(min.x + size.x, min.y, min.z), new Vector3f(min.x + size.x, min.y, min.z + size.z), new Vector3f(min.x, min.y, min.z + size.z), EnumFacing.UP, colorBottom, tex, uvs, mat, inside);
        }
        PanelUtils.addQuad(out, new Vector3f(min.x, min.y, min.z), new Vector3f(min.x, min.y, min.z + size.z), new Vector3f(min.x, min.y + size.y, min.z + size.z), new Vector3f(min.x, min.y + size.y, min.z), EnumFacing.WEST, colorSides, tex, uvs, mat, inside);
        PanelUtils.addQuad(out, new Vector3f(min.x + size.x, min.y, min.z), new Vector3f(min.x + size.x, min.y + size.y, min.z), new Vector3f(min.x + size.x, min.y + size.y, min.z + size.z), new Vector3f(min.x + size.x, min.y, min.z + size.z), EnumFacing.EAST, colorSides, tex, uvs, mat, inside);
        PanelUtils.addQuad(out, new Vector3f(min.x, min.y, min.z), new Vector3f(min.x, min.y + size.y, min.z), new Vector3f(min.x + size.x, min.y + size.y, min.z), new Vector3f(min.x + size.x, min.y, min.z), EnumFacing.NORTH, colorSides, tex, uvs, mat, inside);
        PanelUtils.addQuad(out, new Vector3f(min.x, min.y, min.z + size.z), new Vector3f(min.x + size.x, min.y, min.z + size.z), new Vector3f(min.x + size.x, min.y + size.y, min.z + size.z), new Vector3f(min.x, min.y + size.y, min.z + size.z), EnumFacing.SOUTH, colorSides, tex, uvs, mat, inside);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addColoredQuad(List<RawQuad> out, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, EnumFacing dir, float[] color) {
        PanelUtils.addQuad(out, v0, v1, v2, v3, dir, color, Minecraft.func_71410_x().func_147117_R().getTextureExtry(ModelLoader.White.LOCATION.toString()), UV_FULL, null, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addColoredQuad(List<RawQuad> out, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, EnumFacing dir, float[] color, @Nullable Matrix4 mat) {
        PanelUtils.addQuad(out, v0, v1, v2, v3, dir, color, Minecraft.func_71410_x().func_147117_R().getTextureExtry(ModelLoader.White.LOCATION.toString()), UV_FULL, mat, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addQuad(List<RawQuad> out, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, EnumFacing dir, float[] color, TextureAtlasSprite tex, float[] uvs, @Nullable Matrix4 mat, boolean bidirectional) {
        Vec3i dirV = dir.func_176730_m();
        RawQuad quad = new RawQuad(v0, v1, v2, v3, dir, tex, color, new Vector3f((float)dirV.func_177958_n(), (float)dirV.func_177956_o(), (float)dirV.func_177952_p()), uvs);
        if (mat != null) {
            quad = quad.apply(mat);
        }
        out.add(quad);
        if (bidirectional) {
            dirV = dir.func_176734_d().func_176730_m();
            quad = new RawQuad(v3, v2, v1, v0, dir, tex, color, new Vector3f((float)dirV.func_177958_n(), (float)dirV.func_177956_o(), (float)dirV.func_177952_p()), uvs);
            if (mat != null) {
                quad = quad.apply(mat);
            }
            out.add(quad);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInfo(ItemStack stack, List<String> list, NBTTagCompound data) {
        switch (stack.func_77960_j()) {
            case 0: {
                PanelUtils.addCommonInfo(data, list, true, true);
                if (!data.func_74764_b("latching")) break;
                list.add(I18n.func_135052_a((String)("industrialwires.tooltip." + (data.func_74767_n("latching") ? "latching" : "instantaneous")), (Object[])new Object[0]));
                break;
            }
            case 1: {
                if (data.func_74764_b("text")) {
                    list.add(I18n.func_135052_a((String)"industrialwires.tooltip.text", (Object[])new Object[]{data.func_74779_i("text")}));
                }
                PanelUtils.addCommonInfo(data, list, true, false);
                break;
            }
            case 2: {
                PanelUtils.addCommonInfo(data, list, true, true);
                break;
            }
            case 3: {
                PanelUtils.addCommonInfo(data, list, true, true);
                if (data.func_74764_b("horizontal")) {
                    list.add(I18n.func_135052_a((String)("industrialwires.tooltip." + (data.func_74767_n("horizontal") ? "horizontal" : "vertical")), (Object[])new Object[0]));
                }
                if (!data.func_74764_b("length")) break;
                list.add(I18n.func_135052_a((String)"industrialwires.tooltip.length", (Object[])new Object[]{Float.valueOf(data.func_74760_g("length"))}));
                break;
            }
            case 4: {
                PanelUtils.addCommonInfo(data, list, false, true);
                break;
            }
            case 5: {
                PanelUtils.addCommonInfo(data, list, false, true);
                break;
            }
            case 6: {
                PanelUtils.addCommonInfo(data, list, true, true);
                break;
            }
            case 7: {
                PanelUtils.addCommonInfo(data, list, false, true);
                if (!data.func_74764_b("latching")) break;
                list.add(I18n.func_135052_a((String)("industrialwires.tooltip." + (data.func_74767_n("latching") ? "latching" : "instantaneous")), (Object[])new Object[0]));
                break;
            }
            case 8: {
                PanelUtils.addCommonInfo(data, list, false, true);
                if (!data.func_74764_b("wide")) break;
                list.add(I18n.func_135052_a((String)("industrialwires.tooltip." + (data.func_74767_n("wide") ? "wide" : "narrow")), (Object[])new Object[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addCommonInfo(NBTTagCompound data, List<String> list, boolean color, boolean rs) {
        if (color && data.func_74764_b("color")) {
            String hexCol = String.format("%6s", Integer.toHexString(data.func_74762_e("color") & 0xFFFFFF)).replace(' ', '0');
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
        }
        if (rs && data.func_74764_b("rsChannel")) {
            EnumDyeColor channColor = EnumDyeColor.func_176764_b((int)data.func_74762_e("rsChannel"));
            String hexCol = Integer.toHexString(channColor.func_193350_e());
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{"<hexcol=" + hexCol + ":" + channColor.func_176762_d() + ">"}));
        }
        if (rs && data.func_74764_b("rsId")) {
            list.add(I18n.func_135052_a((String)"industrialwires.tooltip.rsId", (Object[])new Object[]{data.func_74762_e("rsId")}));
        }
    }

    public static int setColor(int color, int id, NBTBase value) {
        id = 2 - id;
        color &= ~(255 << 8 * id);
        return color |= (int)(2.55 * (double)((NBTTagFloat)value).func_150288_h()) << 8 * id;
    }

    public static float[] getFloatColor(boolean active, int color) {
        float[] ret = new float[4];
        ret[3] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            ret[i] = (float)(color >> 8 * (2 - i) & 0xFF) / 255.0f * (active ? 1.0f : 0.5f);
        }
        return ret;
    }

    public static boolean intersectXZ(AxisAlignedBB aabb1, AxisAlignedBB aabb2) {
        return aabb1.field_72340_a < aabb2.field_72336_d && aabb1.field_72336_d > aabb2.field_72340_a && aabb1.field_72339_c < aabb2.field_72334_f && aabb1.field_72334_f > aabb2.field_72339_c;
    }

    public static void readListFromNBT(NBTTagList list, @Nonnull List<PanelComponent> base) {
        boolean allNew;
        boolean bl = allNew = list.func_74745_c() != base.size();
        if (allNew) {
            base.clear();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            PanelComponent pc = PanelComponent.read(nbt);
            if (pc == null) continue;
            if (allNew) {
                base.add(pc);
                continue;
            }
            PanelComponent oldPc = base.get(i);
            if (pc.getClass() != oldPc.getClass()) {
                base.set(i, pc);
                continue;
            }
            oldPc.readFromNBT(nbt);
        }
    }

    public static ItemStack getPanelBase() {
        if (panelBase == null) {
            panelBase = new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.UNFINISHED.ordinal());
        }
        return panelBase;
    }

    public static float getAngle(ItemStack inv) {
        float angle = 0.0f;
        NBTTagCompound nbt = inv.func_77978_p();
        if (nbt != null && nbt.func_74764_b("angle")) {
            angle = nbt.func_74760_g("angle");
        }
        return angle;
    }

    public static float getHeight(ItemStack inv) {
        float height = 0.5f;
        NBTTagCompound nbt = inv.func_77978_p();
        if (nbt != null && nbt.func_74764_b("height")) {
            height = nbt.func_74760_g("height");
        }
        return height;
    }

    public static float getHeightWithComponent(PanelComponent pc, float angle, float height) {
        AxisAlignedBB aabb = pc.getBlockRelativeAABB();
        double y = angle > 0.0f ? aabb.field_72339_c : aabb.field_72334_f;
        float hComp = (float)((double)pc.getHeight() * Math.cos(angle));
        float localPanelHeight = PanelUtils.getLocalHeight(y, angle, height);
        return hComp + localPanelHeight;
    }

    public static float getLocalHeight(double y, float angle, float height) {
        double centerOffset = 0.5 * (1.0 / Math.cos(angle) - 1.0);
        return PanelUtils.getLocalHeightFromZ(Math.cos(angle) * (y += centerOffset), height, angle);
    }

    public static float getLocalHeightFromZ(double z, float height, float angle) {
        return (float)((double)height + (0.5 - z) * Math.tan(angle));
    }

    static {
        UV_FULL = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
        WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }
}

